/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.optgen;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.PositionedError;
import at.dms.compiler.TokenReference;
import at.dms.compiler.tools.antlr.runtime.ParserException;
import at.dms.compiler.tools.optgen.OptgenError;
import at.dms.compiler.tools.optgen.OptgenLexer;
import at.dms.compiler.tools.optgen.OptgenParser;
import at.dms.compiler.tools.optgen.OptionDefinition;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;

class DefinitionFile {
    private final String sourceFile;
    private final String fileHeader;
    private final String packageName;
    private final String parent;
    private final String prefix;
    private String version;
    private final String usage;
    private final OptionDefinition[] definitions;

    public static DefinitionFile read(String string) throws OptgenError {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            OptgenLexer optgenLexer = new OptgenLexer(bufferedInputStream);
            OptgenParser optgenParser = new OptgenParser(optgenLexer);
            DefinitionFile definitionFile = optgenParser.aCompilationUnit(string);
            ((InputStream)bufferedInputStream).close();
            return definitionFile;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OptgenError(CompilerMessages.FILE_NOT_FOUND, string);
        }
        catch (IOException iOException) {
            throw new OptgenError(CompilerMessages.IO_EXCEPTION, string, iOException.getMessage());
        }
        catch (ParserException parserException) {
            throw new OptgenError(CompilerMessages.FORMATTED_ERROR, (Object)new PositionedError(new TokenReference(string, parserException.getLine()), CompilerMessages.SYNTAX_ERROR, (Object)parserException.getMessage()));
        }
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void checkIdentifiers() throws OptgenError {
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].checkIdentifiers(hashtable, this.sourceFile);
            ++n;
        }
    }

    public void checkShortcuts() throws OptgenError {
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].checkShortcuts(hashtable, this.sourceFile);
            ++n;
        }
    }

    public void printFile(PrintWriter printWriter) {
        if (this.fileHeader != null) {
            printWriter.println(this.fileHeader);
        }
        printWriter.print("// Generated by optgen from " + this.sourceFile);
        printWriter.println();
        printWriter.println("package " + this.packageName + ";");
        printWriter.println();
        printWriter.println("import gnu.getopt.Getopt;");
        printWriter.println("import gnu.getopt.LongOpt;");
        printWriter.println();
        printWriter.print("public class " + this.prefix + "Options");
        printWriter.print(this.parent == null ? "" : " extends " + this.parent);
        printWriter.println(" {");
        printWriter.println();
        printWriter.println("  public " + this.prefix + "Options(String name) {");
        printWriter.println("    super(name);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public " + this.prefix + "Options() {");
        printWriter.println("    this(\"" + this.prefix + "\");");
        printWriter.println("  }");
        int n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].printFields(printWriter);
            ++n;
        }
        printWriter.println();
        printWriter.println("  public boolean processOption(int code, Getopt g) {");
        printWriter.println("    switch (code) {");
        n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].printParseArgument(printWriter);
            ++n;
        }
        printWriter.println("    default:");
        printWriter.println("      return super.processOption(code, g);");
        printWriter.println("    }");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public String[] getOptions() {");
        printWriter.println("    String[]\tparent = super.getOptions();");
        printWriter.println("    String[]\ttotal = new String[parent.length + " + this.definitions.length + "];");
        printWriter.println("    System.arraycopy(parent, 0, total, 0, parent.length);");
        n = 0;
        while (n < this.definitions.length) {
            printWriter.print("    total[parent.length + " + n + "] = ");
            this.definitions[n].printUsage(printWriter);
            printWriter.println(";");
            ++n;
        }
        printWriter.println("    ");
        printWriter.println("    return total;");
        printWriter.println("  }");
        printWriter.println("\n");
        printWriter.println("  public String getShortOptions() {");
        printWriter.print("    return \"");
        n = 0;
        while (n < this.definitions.length) {
            this.definitions[n].printShortOption(printWriter);
            ++n;
        }
        printWriter.println("\" + super.getShortOptions();");
        printWriter.println("  }");
        printWriter.println("\n");
        printWriter.println("  public void version() {");
        printWriter.print("    System.out.println(");
        printWriter.print(this.version == null ? "" : "\"" + this.version + "\"");
        printWriter.println(");");
        printWriter.println("  }");
        printWriter.println("\n");
        printWriter.println("  public void usage() {");
        printWriter.print("    System.err.println(");
        printWriter.print(this.usage);
        printWriter.println(");");
        printWriter.println("  }");
        printWriter.println("\n");
        printWriter.println("  public void help() {");
        printWriter.print("    System.err.println(");
        printWriter.print(this.usage);
        printWriter.println(");");
        printWriter.println("    printOptions();");
        printWriter.println("    System.err.println();");
        printWriter.println("    version();");
        printWriter.println("    System.err.println();");
        printWriter.print("    System.err.println(");
        printWriter.print("\"This program is part of the Kopi Suite.\"");
        printWriter.println(");");
        printWriter.print("    System.err.println(");
        printWriter.print("\"For more info, please see: http://www.dms.at/kopi\"");
        printWriter.println(");");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public LongOpt[] getLongOptions() {");
        printWriter.println("    LongOpt[]\tparent = super.getLongOptions();");
        printWriter.println("    LongOpt[]\ttotal = new LongOpt[parent.length + LONGOPTS.length];");
        printWriter.println("    ");
        printWriter.println("    System.arraycopy(parent, 0, total, 0, parent.length);");
        printWriter.println("    System.arraycopy(LONGOPTS, 0, total, parent.length, LONGOPTS.length);");
        printWriter.println("    ");
        printWriter.println("    return total;");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  private static final LongOpt[] LONGOPTS = {");
        n = 0;
        while (n < this.definitions.length) {
            if (n != 0) {
                printWriter.println(",");
            }
            this.definitions[n].printLongOpts(printWriter);
            ++n;
        }
        printWriter.println();
        printWriter.println("  };");
        printWriter.println("}");
    }

    public String getClassName() {
        return this.packageName + "." + this.prefix + "Options";
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public DefinitionFile(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, OptionDefinition[] optionDefinitionArray) {
        this.sourceFile = string;
        this.fileHeader = string2;
        this.packageName = string3;
        this.parent = string4;
        this.version = string6 == null ? null : string6.substring(1, string6.length() - 1);
        this.usage = string7;
        this.prefix = string5;
        this.definitions = optionDefinitionArray;
    }
}

