/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.msggen;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.tools.msggen.DefinitionFile;
import at.dms.compiler.tools.msggen.MsggenError;
import at.dms.compiler.tools.msggen.MsggenOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Main {
    private MsggenOptions options;
    private DefinitionFile definition;

    public static void main(String[] stringArray) {
        boolean bl = new Main().run(stringArray);
        System.exit(bl ? 0 : 1);
    }

    private boolean run(String[] stringArray) {
        if (!this.parseArguments(stringArray)) {
            return false;
        }
        if (!this.parseSourceFiles()) {
            return false;
        }
        if (!this.checkIdentifiers()) {
            return false;
        }
        return this.buildInterfaceFile();
    }

    private boolean parseArguments(String[] stringArray) {
        this.options = new MsggenOptions();
        if (!this.options.parseCommandLine(stringArray)) {
            return false;
        }
        if (this.options.nonOptions.length == 0) {
            System.err.println(CompilerMessages.NO_INPUT_FILE.getFormat());
            return false;
        }
        if (this.options.nonOptions.length > 1) {
            this.options.usage();
            return false;
        }
        return true;
    }

    private boolean parseSourceFiles() {
        boolean bl = false;
        try {
            this.definition = DefinitionFile.read(this.options.nonOptions[0]);
        }
        catch (MsggenError msggenError) {
            System.err.println(msggenError.getMessage());
            bl = true;
        }
        return !bl;
    }

    private boolean checkIdentifiers() {
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        try {
            this.definition.checkIdentifiers(hashtable);
        }
        catch (MsggenError msggenError) {
            System.err.println(msggenError.getMessage());
            bl = true;
        }
        return !bl;
    }

    private boolean buildInterfaceFile() {
        String string = this.definition.getPrefix();
        File file = new File(string + "Messages.java");
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            this.definition.printFile(printWriter);
            printWriter.flush();
            printWriter.close();
            return true;
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception on " + file.getPath() + ": " + iOException.getMessage());
            return false;
        }
    }

    private Main() {
    }
}

