/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.jperf;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.Random;

public class Table {
    private static Random random = new Random(new Date().getTime());
    private final String tableName;
    private final int maxWordLength;
    private final char minCharValue;
    private final char maxCharValue;
    private Hashtable[] heads;

    public void init() {
        this.heads = new Hashtable[this.maxWordLength];
        int n = 0;
        while (n < this.maxWordLength) {
            this.heads[n] = new Hashtable();
            ++n;
        }
    }

    public long insertKey(String string, long l) {
        long l2 = 0L;
        int n = 0;
        while (n < string.length()) {
            Character c = new Character(string.charAt(n));
            Long l3 = (Long)this.heads[n].get(c);
            if (l3 != null) {
                l2 += l3.longValue();
            } else {
                long l4 = Math.abs(random.nextLong()) % l;
                this.heads[n].put(c, new Long(l4));
                l2 += l4;
            }
            ++n;
        }
        return l2 % l;
    }

    public long getKeyValue(String string) {
        long l = 0L;
        int n = 0;
        while (n < string.length()) {
            Character c = new Character(string.charAt(n));
            Long l2 = (Long)this.heads[n].get(c);
            if (l2 == null) {
                System.err.println("Internal fatal error: can't find table items for " + string);
                System.exit(-1);
            }
            l += l2.longValue();
            ++n;
        }
        return l;
    }

    public void genCode(PrintWriter printWriter) {
        printWriter.println("    private static final int[][] " + this.tableName + " = {");
        int n = 0;
        while (n < this.heads.length) {
            Hashtable hashtable = this.heads[n];
            printWriter.print("    {");
            char c = this.minCharValue;
            while (c <= this.maxCharValue) {
                Character c2 = new Character(c);
                if (c != this.minCharValue) {
                    printWriter.print(",");
                }
                if (hashtable.containsKey(c2)) {
                    printWriter.print((Long)hashtable.get(c2));
                } else {
                    printWriter.print("-1");
                }
                c = (char)(c + '\u0001');
            }
            if (n < this.heads.length - 1) {
                printWriter.println("},");
            } else {
                printWriter.println("}");
            }
            ++n;
        }
        printWriter.println("    };");
    }

    public Table(String string, int n, char c, char c2) {
        this.tableName = string;
        this.maxWordLength = n;
        this.minCharValue = c;
        this.maxCharValue = c2;
    }
}

