/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.jperf;

import at.dms.compiler.tools.jperf.Node;
import java.io.PrintWriter;
import java.util.Vector;

class Graph {
    private final long maxNodeValue;
    private Vector nodes;

    public void init() {
        this.nodes = new Vector();
    }

    public void addNode(Node node) {
        this.nodes.addElement(node);
    }

    public Node findNode(long l) {
        if (l >= this.maxNodeValue) {
            System.err.println("Internal fatal error: try to find invalid vertex label " + l + ".");
            System.exit(-1);
        }
        int n = 0;
        while (n < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n);
            if (node.getLabel() == l) {
                return node;
            }
            ++n;
        }
        return null;
    }

    public boolean addEdge(long l, long l2, long l3) {
        if (l >= this.maxNodeValue) {
            System.err.println("Internal error: invalid node label " + l + ".");
            System.exit(-1);
        }
        if (l2 >= this.maxNodeValue) {
            System.err.println("Internal error: invalid node label " + l2 + ".");
            System.exit(-1);
        }
        if (l == l2) {
            return false;
        }
        Node node = this.findNode(l);
        Node node2 = this.findNode(l2);
        if (node != null && node2 != null) {
            this.clearVisited();
            if (node.reaches(node2)) {
                return false;
            }
        } else {
            if (node == null) {
                node = new Node(l);
                this.addNode(node);
            }
            if (node2 == null) {
                node2 = new Node(l2);
                this.addNode(node2);
            }
        }
        node.addAdjacency(node2, l3);
        node2.addAdjacency(node, l3);
        return true;
    }

    public void clearVisited() {
        int n = 0;
        while (n < this.nodes.size()) {
            ((Node)this.nodes.elementAt(n)).setVisited(false);
            ++n;
        }
    }

    public void assignGValues(int n) {
        int n2 = 0;
        while (n2 < this.nodes.size()) {
            ((Node)this.nodes.elementAt(n2)).assignGValue(0L, n);
            ++n2;
        }
    }

    public void genCode(PrintWriter printWriter) {
        Node node;
        printWriter.println("  private static final int MAX_NODE_NUM = " + this.nodes.size() + ";");
        int n = this.nodes.size();
        printWriter.println("  private static final int gIndex(int n) {");
        printWriter.println("    switch(n) {");
        int n2 = 0;
        boolean bl = false;
        while (n2 < n) {
            node = (Node)this.nodes.elementAt(n2);
            if (node.getGValue() == 0L) {
                printWriter.println("    case " + node.getLabel() + ":");
            }
            ++n2;
        }
        printWriter.println("      return 0;");
        n2 = 0;
        bl = false;
        while (n2 < n) {
            node = (Node)this.nodes.elementAt(n2);
            if (node.getGValue() != 0L) {
                printWriter.println("    case " + node.getLabel() + ":");
                printWriter.println("      return " + node.getGValue() + ";");
            }
            ++n2;
        }
        printWriter.println("    default:");
        printWriter.println("      return -1;");
        printWriter.println("    }");
        printWriter.println("  }");
    }

    public Graph(long l) {
        this.maxNodeValue = l;
    }
}

