/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.include;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.tools.include.IncludeError;
import at.dms.compiler.tools.include.IncludeMessages;
import at.dms.compiler.tools.include.IncludeOptions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Main {
    private IncludeOptions options;

    private void run() throws IncludeError {
        PrintWriter printWriter;
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.options.nonOptions[0]));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IncludeError(CompilerMessages.FILE_NOT_FOUND, this.options.nonOptions[0]);
        }
        if (this.options.output == null) {
            printWriter = new PrintWriter(System.out);
        } else {
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.options.output)));
            }
            catch (IOException iOException) {
                throw new IncludeError(IncludeMessages.CANNOT_OPEN_FILE, this.options.output, iOException.getMessage());
            }
        }
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() > 0 && string.startsWith(this.options.pattern)) {
                    this.includeFile(this.options.directory, string.substring(this.options.pattern.length()).trim(), printWriter);
                    continue;
                }
                printWriter.println(string);
            }
        }
        catch (IOException iOException) {
            throw new IncludeError(CompilerMessages.IO_EXCEPTION, this.options.nonOptions[0], iOException.getMessage());
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new IncludeError(CompilerMessages.IO_EXCEPTION, this.options.nonOptions[0], iOException.getMessage());
        }
        printWriter.flush();
        printWriter.close();
    }

    private void includeFile(String string, String string2, PrintWriter printWriter) throws IncludeError {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(string, string2)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IncludeError(CompilerMessages.FILE_NOT_FOUND, string2);
        }
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                printWriter.println(string3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new IncludeError(CompilerMessages.IO_EXCEPTION, string2, iOException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        new Main(stringArray);
    }

    private boolean parseArguments(String[] stringArray) {
        this.options = new IncludeOptions();
        return this.options.parseCommandLine(stringArray);
    }

    private Main(String[] stringArray) {
        String[] stringArray2;
        if (!this.parseArguments(stringArray)) {
            System.exit(1);
        }
        if ((stringArray2 = this.options.nonOptions).length == 0) {
            this.options.usage();
            System.err.println(CompilerMessages.NO_INPUT_FILE.getFormat());
            System.exit(1);
        } else if (stringArray2.length > 1) {
            this.options.usage();
            System.exit(1);
        } else {
            try {
                this.run();
                System.exit(0);
            }
            catch (IncludeError includeError) {
                System.err.println(includeError.getMessage());
                System.exit(1);
            }
        }
    }
}

