/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.antlr.compiler;

import at.dms.compiler.tools.antlr.compiler.ANTLRTokdefLexer;
import at.dms.compiler.tools.antlr.compiler.ANTLRTokdefParser;
import at.dms.compiler.tools.antlr.compiler.Grammar;
import at.dms.compiler.tools.antlr.compiler.Main;
import at.dms.compiler.tools.antlr.compiler.SimpleTokenManager;
import at.dms.compiler.tools.antlr.compiler.StringLiteralSymbol;
import at.dms.compiler.tools.antlr.compiler.TokenSymbol;
import at.dms.compiler.tools.antlr.compiler.Utils;
import at.dms.compiler.tools.antlr.runtime.RecognitionException;
import at.dms.compiler.tools.antlr.runtime.TokenStreamException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

class ImportVocabTokenManager
extends SimpleTokenManager
implements Cloneable {
    private String filename;
    protected Grammar grammar;

    public Object clone() {
        ImportVocabTokenManager importVocabTokenManager = (ImportVocabTokenManager)super.clone();
        importVocabTokenManager.filename = this.filename;
        importVocabTokenManager.grammar = this.grammar;
        return importVocabTokenManager;
    }

    public void define(TokenSymbol tokenSymbol) {
        if (this.readOnly) {
            String string = tokenSymbol.getParaphrase();
            if (string == null) {
                string = tokenSymbol.getId();
            }
            this.tool.error("Cannot redefine token " + string + ": vocabulary is read-only");
        }
        super.define(tokenSymbol);
    }

    public void define(String string, int n) {
        TokenSymbol tokenSymbol = null;
        tokenSymbol = string.startsWith("\"") ? new StringLiteralSymbol(string) : new TokenSymbol(string);
        tokenSymbol.setTokenType(n);
        super.define(tokenSymbol);
        this.maxToken = n + 1 > this.maxToken ? n + 1 : this.maxToken;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int nextTokenType() {
        return super.nextTokenType();
    }

    ImportVocabTokenManager(Grammar grammar, String string, String string2, Main main) {
        super(string2, main);
        this.grammar = grammar;
        File file = new File(string);
        if (!file.exists() && !(file = new File(this.tool.getOutputDirectory(), string)).exists()) {
            Utils.panic("Cannot find importVocab file '" + this.filename);
        }
        this.filename = string;
        this.setReadOnly(true);
        try {
            FileReader fileReader = new FileReader(file);
            ANTLRTokdefLexer aNTLRTokdefLexer = new ANTLRTokdefLexer(fileReader);
            ANTLRTokdefParser aNTLRTokdefParser = new ANTLRTokdefParser(aNTLRTokdefLexer);
            aNTLRTokdefParser.setFilename(this.filename);
            aNTLRTokdefParser.file(this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utils.panic("Cannot find importVocab file '" + this.filename);
        }
        catch (RecognitionException recognitionException) {
            Utils.panic("Error parsing importVocab file '" + this.filename + "': " + recognitionException.toString());
        }
        catch (TokenStreamException tokenStreamException) {
            Utils.panic("Error reading importVocab file '" + this.filename + "'");
        }
    }
}

