/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler.tools.antlr.compiler;

import at.dms.compiler.tools.antlr.compiler.GrammarDefinition;
import at.dms.compiler.tools.antlr.compiler.GrammarFile;
import at.dms.compiler.tools.antlr.compiler.IndexedVector;
import at.dms.compiler.tools.antlr.compiler.Option;
import at.dms.compiler.tools.antlr.compiler.Preprocessor;
import at.dms.compiler.tools.antlr.compiler.PreprocessorLexer;
import at.dms.compiler.tools.antlr.compiler.Utils;
import at.dms.compiler.tools.antlr.runtime.ANTLRException;
import at.dms.compiler.tools.antlr.runtime.TokenStreamException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Hierarchy {
    private static GrammarDefinition LexerRoot = new GrammarDefinition("Lexer", null, null);
    private static GrammarDefinition ParserRoot = new GrammarDefinition("Parser", null, null);
    private Hashtable symbols = new Hashtable(10);
    private Hashtable files = new Hashtable(10);

    public void addGrammar(GrammarDefinition grammarDefinition) {
        grammarDefinition.setHierarchy(this);
        this.symbols.put(grammarDefinition.getName(), grammarDefinition);
        GrammarFile grammarFile = this.getFile(grammarDefinition.getFileName());
        grammarFile.addGrammar(grammarDefinition);
    }

    public void addGrammarFile(GrammarFile grammarFile) {
        this.files.put(grammarFile.getName(), grammarFile);
    }

    public void expandGrammarsInFile(String string) {
        GrammarFile grammarFile = this.getFile(string);
        Enumeration enumeration = grammarFile.getGrammars().elements();
        while (enumeration.hasMoreElements()) {
            GrammarDefinition grammarDefinition = (GrammarDefinition)enumeration.nextElement();
            grammarDefinition.expandInPlace();
        }
    }

    public GrammarDefinition findRoot(GrammarDefinition grammarDefinition) {
        if (grammarDefinition.getSuperGrammarName() == null) {
            return grammarDefinition;
        }
        GrammarDefinition grammarDefinition2 = grammarDefinition.getSuperGrammar();
        if (grammarDefinition2 == null) {
            return grammarDefinition;
        }
        return this.findRoot(grammarDefinition2);
    }

    public GrammarFile getFile(String string) {
        return (GrammarFile)this.files.get(string);
    }

    public GrammarDefinition getGrammar(String string) {
        return (GrammarDefinition)this.symbols.get(string);
    }

    public static String optionsToString(IndexedVector indexedVector) {
        String string = "options {" + System.getProperty("line.separator");
        Enumeration enumeration = indexedVector.elements();
        while (enumeration.hasMoreElements()) {
            string = string + (Option)enumeration.nextElement() + System.getProperty("line.separator");
        }
        string = string + "}" + System.getProperty("line.separator") + System.getProperty("line.separator");
        return string;
    }

    public void readGrammarFile(String string) throws FileNotFoundException {
        FileReader fileReader = new FileReader(string);
        this.addGrammarFile(new GrammarFile(string));
        PreprocessorLexer preprocessorLexer = new PreprocessorLexer(fileReader);
        preprocessorLexer.setFilename(string);
        Preprocessor preprocessor = new Preprocessor(preprocessorLexer);
        preprocessor.setFilename(string);
        try {
            preprocessor.grammarFile(this, string);
        }
        catch (TokenStreamException tokenStreamException) {
            Utils.toolError("Token stream error reading grammar(s):" + tokenStreamException);
        }
        catch (ANTLRException aNTLRException) {
            Utils.toolError("error reading grammar(s):" + aNTLRException);
        }
    }

    public boolean verifyThatHierarchyIsComplete() {
        GrammarDefinition grammarDefinition;
        boolean bl = true;
        Enumeration enumeration = this.symbols.elements();
        while (enumeration.hasMoreElements()) {
            GrammarDefinition grammarDefinition2;
            grammarDefinition = (GrammarDefinition)enumeration.nextElement();
            if (grammarDefinition.getSuperGrammarName() == null || (grammarDefinition2 = grammarDefinition.getSuperGrammar()) != null) continue;
            Utils.toolError("grammar " + grammarDefinition.getSuperGrammarName() + " not defined");
            bl = false;
            this.symbols.remove(grammarDefinition.getName());
        }
        if (!bl) {
            return false;
        }
        enumeration = this.symbols.elements();
        while (enumeration.hasMoreElements()) {
            grammarDefinition = (GrammarDefinition)enumeration.nextElement();
            if (grammarDefinition.getSuperGrammarName() == null) continue;
            grammarDefinition.setType(this.findRoot(grammarDefinition).getName());
        }
        return true;
    }

    public Hierarchy() {
        LexerRoot.setPredefined(true);
        ParserRoot.setPredefined(true);
        this.symbols.put(LexerRoot.getName(), LexerRoot);
        this.symbols.put(ParserRoot.getName(), ParserRoot);
    }
}

