/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler;

public class NumberParser {
    public static long decodeLong(String string) {
        boolean bl;
        if (string.startsWith("-")) {
            bl = true;
            string = string.substring(1);
        } else {
            bl = false;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return NumberParser.decodeHexLong(bl, string.substring(2));
        }
        if (string.startsWith("0")) {
            return NumberParser.decodeOctLong(bl, string);
        }
        return NumberParser.decodeDecLong(bl, string);
    }

    public static int decodeInt(String string) {
        boolean bl;
        if (string.startsWith("-")) {
            bl = true;
            string = string.substring(1);
        } else {
            bl = false;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return NumberParser.decodeHexInt(bl, string.substring(2));
        }
        if (string.startsWith("0")) {
            return NumberParser.decodeOctInt(bl, string);
        }
        if (string.equals("2147483648") && bl) {
            return Integer.MIN_VALUE;
        }
        if (bl) {
            return -Integer.decode(string).intValue();
        }
        return Integer.decode(string);
    }

    public static long decodeDecLong(boolean bl, String string) {
        long l = 0L;
        int n = 0;
        while (n < string.length()) {
            int n2 = Character.digit(string.charAt(n), 10);
            if (n2 == -1) {
                throw new NumberFormatException("invalid digit");
            }
            if (l < -922337203685477580L) {
                throw new NumberFormatException("overflow");
            }
            if ((l *= 10L) < Long.MIN_VALUE + (long)n2) {
                throw new NumberFormatException("overflow");
            }
            l -= (long)n2;
            ++n;
        }
        if (l == Long.MIN_VALUE && !bl) {
            throw new NumberFormatException("overflow");
        }
        if (bl) {
            return l;
        }
        return -l;
    }

    public static long decodeHexLong(boolean bl, String string) {
        if (string.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (n < string.length()) {
            int n2 = Character.digit(string.charAt(n), 16);
            if (n2 == -1) {
                throw new NumberFormatException("invalid digit");
            }
            if (n2 != 0 || l2 != 0L) {
                if (l2 == 16L) {
                    throw new NumberFormatException("overflow");
                }
                l = l << 4 | (long)n2;
                ++l2;
            }
            ++n;
        }
        if (bl) {
            return -l;
        }
        return l;
    }

    public static long decodeOctLong(boolean bl, String string) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (n < string.length()) {
            int n2 = Character.digit(string.charAt(n), 8);
            if (n2 == -1) {
                throw new NumberFormatException("invalid digit");
            }
            if (n2 != 0 || l2 != 0L) {
                if (l2 == 22L) {
                    throw new NumberFormatException("overflow");
                }
                if (l2 == 21L && (l & 0x6000000000000000L) != 0L) {
                    throw new NumberFormatException("overflow");
                }
                l = l << 3 | (long)n2;
                ++l2;
            }
            ++n;
        }
        if (bl) {
            return -l;
        }
        return l;
    }

    public static int decodeHexInt(boolean bl, String string) {
        if (string.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            int n4 = Character.digit(string.charAt(n3), 16);
            if (n4 == -1) {
                throw new NumberFormatException("invalid digit");
            }
            if (n4 != 0 || n2 != 0) {
                if (n2 == 8) {
                    throw new NumberFormatException("overflow");
                }
                n = n << 4 | n4;
                ++n2;
            }
            ++n3;
        }
        if (bl) {
            return -n;
        }
        return n;
    }

    public static int decodeOctInt(boolean bl, String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            int n4 = Character.digit(string.charAt(n3), 8);
            if (n4 == -1) {
                throw new NumberFormatException("invalid digit");
            }
            if (n4 != 0 || n2 != 0) {
                if (n2 == 11) {
                    throw new NumberFormatException("overflow");
                }
                if (n2 == 10 && (n & 0x20000000) != 0) {
                    throw new NumberFormatException("overflow");
                }
                n = n << 3 | n4;
                ++n2;
            }
            ++n3;
        }
        if (bl) {
            return -n;
        }
        return n;
    }
}

