/*
 * Decompiled with CFR 0.152.
 */
package at.dms.compiler;

import at.dms.compiler.CompilerMessages;
import at.dms.compiler.PositionedError;
import at.dms.compiler.UnpositionedError;
import at.dms.util.Message;
import at.dms.util.MessageDescription;
import at.dms.util.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Compiler {
    private final long timestamp;
    private PrintWriter err = new PrintWriter(System.err);
    private String workingDirectory;
    private static /* synthetic */ Class class$Ljava$lang$String;

    protected void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public File[] verifyFiles(String[] stringArray) throws UnpositionedError {
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].startsWith("@")) {
                vector.addElement(stringArray[n]);
            } else {
                try {
                    this.readList(vector, this.workingDirectory, stringArray[n]);
                }
                catch (IOException iOException) {
                    throw new UnpositionedError(CompilerMessages.INVALID_LIST_FILE, stringArray[n], iOException.getMessage());
                }
            }
            ++n;
        }
        File[] fileArray = new File[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = this.workingDirectory == null ? (String)vector.elementAt(n2) : this.workingDirectory + File.separatorChar + (String)vector.elementAt(n2);
            File file = new File(string);
            if (!(file.exists() || (file = new File((String)vector.elementAt(n2))).exists() && file.isAbsolute())) {
                throw new UnpositionedError(CompilerMessages.FILE_NOT_FOUND, vector.elementAt(n2), null);
            }
            fileArray[n2] = file;
            ++n2;
        }
        return fileArray;
    }

    public Vector verifyFiles(Vector vector) throws UnpositionedError {
        return Utils.toVector(this.verifyFiles((String[])Utils.toArray(vector, class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Compiler.class$("java.lang.String")))));
    }

    private void readList(Vector vector, String string, String string2) throws IOException {
        String string3;
        File file = new File((string == null ? "" : string + File.separatorChar) + string2.substring(1));
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        while ((string3 = lineNumberReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        }
    }

    protected String checkDestination(String string) {
        if (this.workingDirectory == null) {
            return string;
        }
        if (string == null || string.equals("")) {
            return this.workingDirectory;
        }
        if (new File(string).isAbsolute()) {
            return string;
        }
        return this.workingDirectory + File.separatorChar + string;
    }

    public boolean run(String string, PrintWriter printWriter, String[] stringArray) {
        this.workingDirectory = string;
        this.err = printWriter;
        return this.run(stringArray);
    }

    public abstract boolean run(String[] var1);

    public abstract void reportTrouble(PositionedError var1);

    public abstract boolean parseComments();

    public abstract boolean verboseMode();

    public void inform(UnpositionedError unpositionedError) {
        this.inform(unpositionedError.getMessage());
    }

    public void inform(PositionedError positionedError) {
        this.inform(positionedError.getMessage());
    }

    public void inform(Message message) {
        this.inform(message.getMessage());
    }

    public void inform(MessageDescription messageDescription, Object[] objectArray) {
        this.inform(new Message(messageDescription, objectArray));
    }

    public void inform(MessageDescription messageDescription, Object object, Object object2) {
        this.inform(messageDescription, new Object[]{object, object2});
    }

    public void inform(MessageDescription messageDescription, Object object) {
        this.inform(messageDescription, new Object[]{object});
    }

    public void inform(MessageDescription messageDescription) {
        this.inform(messageDescription, null);
    }

    private void inform(String string) {
        this.err.println(string);
        this.err.flush();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Compiler() {
        this.timestamp = System.currentTimeMillis();
    }
}

