/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LineNumberInfo
implements AccessorContainer {
    private int line;
    private InstructionAccessor inst;

    public void transformAccessors(AccessorTransformer accessorTransformer) throws BadAccessorException {
        this.inst = this.inst.transform(accessorTransformer, this);
    }

    public int getLine() {
        return this.line;
    }

    public InstructionAccessor getInstruction() {
        return this.inst;
    }

    public void setInstruction(InstructionAccessor instructionAccessor) {
        this.inst = instructionAccessor;
    }

    void write(DataOutput dataOutput) throws IOException {
        Instruction instruction = (Instruction)this.inst;
        dataOutput.writeShort(instruction.getAddress());
        dataOutput.writeShort((short)this.line);
    }

    public LineNumberInfo(short s, InstructionAccessor instructionAccessor) {
        this.line = s;
        this.inst = instructionAccessor;
    }

    public LineNumberInfo(DataInput dataInput, ConstantPool constantPool, Instruction[] instructionArray) throws IOException {
        int n = dataInput.readUnsignedShort();
        if (n < instructionArray.length) {
            this.inst = instructionArray[n];
        }
        this.line = dataInput.readUnsignedShort();
    }
}

