/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.ClassConstant;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Constants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InnerClassInfo
implements Constants {
    private static final int MODIFIER_MASK = 1567;
    private ClassConstant innerClass;
    private ClassConstant outerClass;
    private AsciiConstant simpleName;
    private short modifiers;

    public String getQualifiedName() {
        return this.innerClass.getName();
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(this.innerClass);
        if (this.outerClass != null) {
            constantPool.addItem(this.outerClass);
        }
        if (this.simpleName != null) {
            constantPool.addItem(this.simpleName);
        }
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.innerClass.getIndex());
        dataOutput.writeShort(this.outerClass == null ? 0 : (int)this.outerClass.getIndex());
        dataOutput.writeShort(this.simpleName == null ? 0 : (int)this.simpleName.getIndex());
        dataOutput.writeShort(this.modifiers & 0x61F);
    }

    public InnerClassInfo(String string, String string2, String string3, short s) {
        this.innerClass = new ClassConstant(string);
        this.outerClass = string2 == null ? null : new ClassConstant(string2);
        this.simpleName = string3 == null ? null : new AsciiConstant(string3);
        this.modifiers = s;
    }

    public InnerClassInfo(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this.innerClass = (ClassConstant)constantPool.getEntryAt(dataInput.readUnsignedShort());
        int n = dataInput.readUnsignedShort();
        this.outerClass = n == 0 ? null : (ClassConstant)constantPool.getEntryAt(n);
        int n2 = dataInput.readUnsignedShort();
        this.simpleName = n2 == 0 ? null : (AsciiConstant)constantPool.getEntryAt(n2);
        this.modifiers = (short)dataInput.readUnsignedShort();
    }
}

