/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AccessorContainer;
import at.dms.classfile.AccessorTransformer;
import at.dms.classfile.BadAccessorException;
import at.dms.classfile.ClassConstant;
import at.dms.classfile.ConstantPool;
import at.dms.classfile.Instruction;
import at.dms.classfile.InstructionAccessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class HandlerInfo
implements AccessorContainer {
    private InstructionAccessor start;
    private InstructionAccessor end;
    private InstructionAccessor handler;
    private ClassConstant thrown;

    public void transformAccessors(AccessorTransformer accessorTransformer) throws BadAccessorException {
        this.start = this.start.transform(accessorTransformer, this);
        this.end = this.end.transform(accessorTransformer, this);
        this.handler = this.handler.transform(accessorTransformer, this);
    }

    public void setStart(InstructionAccessor instructionAccessor) {
        this.start = instructionAccessor;
    }

    public InstructionAccessor getStart() {
        return this.start;
    }

    public void setEnd(InstructionAccessor instructionAccessor) {
        this.end = instructionAccessor;
    }

    public InstructionAccessor getEnd() {
        return this.end;
    }

    public void setHandler(InstructionAccessor instructionAccessor) {
        this.handler = instructionAccessor;
    }

    public InstructionAccessor getHandler() {
        return this.handler;
    }

    public String getThrown() {
        return this.thrown == null ? null : this.thrown.getName();
    }

    void resolveConstants(ConstantPool constantPool) {
        if (this.thrown != null) {
            constantPool.addItem(this.thrown);
        }
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeShort((short)((Instruction)this.start).getAddress());
        dataOutput.writeShort((short)(((Instruction)this.end).getAddress() + ((Instruction)this.end).getSize()));
        dataOutput.writeShort((short)((Instruction)this.handler).getAddress());
        dataOutput.writeShort(this.thrown == null ? 0 : (int)this.thrown.getIndex());
    }

    public HandlerInfo(InstructionAccessor instructionAccessor, InstructionAccessor instructionAccessor2, InstructionAccessor instructionAccessor3, String string) {
        this.start = instructionAccessor;
        this.end = instructionAccessor2;
        this.handler = instructionAccessor3;
        this.thrown = string == null ? null : new ClassConstant(string);
    }

    public HandlerInfo(DataInput dataInput, ConstantPool constantPool, Instruction[] instructionArray) throws IOException {
        this.start = instructionArray[dataInput.readUnsignedShort()];
        int n = dataInput.readUnsignedShort() - 1;
        while (instructionArray[n] == null) {
            --n;
        }
        this.end = instructionArray[n];
        this.handler = instructionArray[dataInput.readUnsignedShort()];
        int n2 = dataInput.readUnsignedShort();
        this.thrown = n2 == 0 ? null : (ClassConstant)constantPool.getEntryAt(n2);
    }
}

