/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.ConstantPool;
import at.dms.classfile.FieldRefConstant;
import at.dms.classfile.Instruction;
import at.dms.util.InconsistencyException;
import java.io.DataOutput;
import java.io.IOException;

public class FieldRefInstruction
extends Instruction {
    private FieldRefConstant field;

    public boolean canComplete() {
        return true;
    }

    void resolveConstants(ConstantPool constantPool) {
        constantPool.addItem(this.field);
    }

    int getSize() {
        return 3;
    }

    public FieldRefConstant getFieldRefConstant() {
        return this.field;
    }

    public byte getReturnType() {
        switch (this.field.getType().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 4;
            }
            case 'F': {
                return 3;
            }
            case 'L': 
            case '[': {
                return 6;
            }
            case 'D': {
                return 2;
            }
            case 'J': {
                return 5;
            }
        }
        throw new InconsistencyException("invalid signature " + this.field.getType());
    }

    public int getPushedOnStack() {
        int n = this.getStack();
        switch (this.getOpcode()) {
            case 178: {
                return n;
            }
            case 179: {
                return 0;
            }
            case 180: {
                return n + 1;
            }
            case 181: {
                return 0;
            }
        }
        return 0;
    }

    public int getStack() {
        int n;
        switch (this.field.getType().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                n = 1;
                break;
            }
            case 'D': 
            case 'J': {
                n = 2;
                break;
            }
            default: {
                throw new InconsistencyException("invalid signature " + this.field.getType());
            }
        }
        switch (this.getOpcode()) {
            case 178: {
                return n;
            }
            case 179: {
                return -n;
            }
            case 180: {
                return n - 1;
            }
            case 181: {
                return -n - 1;
            }
        }
        throw new InconsistencyException("invalid opcode: " + this.getOpcode());
    }

    void write(ConstantPool constantPool, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte((byte)this.getOpcode());
        dataOutput.writeShort(this.field.getIndex());
    }

    public FieldRefInstruction(int n, String string, String string2) {
        super(n);
        this.field = new FieldRefConstant(string, string2);
    }

    public FieldRefInstruction(int n, String string, String string2, String string3) {
        super(n);
        this.field = new FieldRefConstant(string, string2, string3);
    }

    public FieldRefInstruction(int n, FieldRefConstant fieldRefConstant) {
        super(n);
        this.field = fieldRefConstant;
    }
}

