/*
 * Decompiled with CFR 0.152.
 */
package at.dms.classfile;

import at.dms.classfile.AsciiConstant;
import at.dms.classfile.ClassFileFormatException;
import at.dms.classfile.Constants;
import at.dms.classfile.DoubleConstant;
import at.dms.classfile.FloatConstant;
import at.dms.classfile.Hashtables;
import at.dms.classfile.IntegerConstant;
import at.dms.classfile.LongConstant;
import at.dms.classfile.PooledArray;
import at.dms.classfile.PooledConstant;
import at.dms.classfile.UnresolvedConstant;
import at.dms.util.InconsistencyException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;

public class ConstantPool
implements Constants {
    public static int MAX_ENTRY = 65535;
    private boolean newOne;
    private int countItems = 1;
    private Hashtable items;
    private PooledConstant[] table = PooledArray.getPooledArray();

    public void close() {
        Hashtables.release(this.items);
        PooledArray.release(this.table);
    }

    final void addItem(PooledConstant pooledConstant) {
        PooledConstant pooledConstant2 = this.items.put(pooledConstant, pooledConstant);
        if (pooledConstant2 == null) {
            pooledConstant.resolveConstants(this);
            if (this.countItems == this.table.length) {
                throw new InconsistencyException("CLASS CODE EXCEED MAX ALLOWED SIZE");
            }
            this.table[this.countItems] = pooledConstant;
            pooledConstant.setIndex((short)this.countItems);
            this.countItems += pooledConstant.getSlotsUsed();
        } else {
            pooledConstant.resolveConstants(pooledConstant2);
        }
        if (pooledConstant.getIndex() == 0) {
            throw new InconsistencyException();
        }
    }

    final PooledConstant getEntryAt(int n) {
        return this.table[n];
    }

    void write(DataOutput dataOutput) throws IOException {
        if (!this.newOne) {
            this.items = new Hashtable(this.table.length);
            PooledConstant[] pooledConstantArray = this.table;
            this.table = new PooledConstant[pooledConstantArray.length];
            int n = 1;
            while (n < this.countItems) {
                this.addItem(pooledConstantArray[n]);
                n += pooledConstantArray[n].getSlotsUsed();
            }
        }
        dataOutput.writeShort((short)this.countItems);
        int n = 1;
        while (n < this.countItems) {
            this.table[n].write(this, dataOutput);
            this.table[n - 1] = null;
            n += this.table[n].getSlotsUsed();
        }
        this.table[this.countItems - 1] = null;
    }

    public ConstantPool() {
        this.items = Hashtables.getHashtable();
        this.countItems = 1;
        this.newOne = true;
    }

    public ConstantPool(DataInput dataInput) throws IOException, ClassFileFormatException {
        int n;
        this.countItems = n = dataInput.readUnsignedShort();
        int[] nArray = new int[n];
        int n2 = 1;
        while (n2 < n) {
            byte by = (byte)dataInput.readUnsignedByte();
            switch (by) {
                case 1: {
                    this.table[n2] = new AsciiConstant(dataInput.readUTF().intern());
                    break;
                }
                case 3: {
                    this.table[n2] = new IntegerConstant(dataInput.readInt());
                    break;
                }
                case 4: {
                    this.table[n2] = new FloatConstant(dataInput.readFloat());
                    break;
                }
                case 5: {
                    this.table[n2] = new LongConstant(dataInput.readLong());
                    ++n2;
                    break;
                }
                case 6: {
                    this.table[n2] = new DoubleConstant(dataInput.readDouble());
                    ++n2;
                    break;
                }
                case 7: {
                    this.table[n2] = new UnresolvedConstant(7, dataInput.readUnsignedShort(), 0);
                    nArray[n2] = 1;
                    break;
                }
                case 8: {
                    this.table[n2] = new UnresolvedConstant(8, dataInput.readUnsignedShort(), 0);
                    nArray[n2] = 1;
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.table[n2] = new UnresolvedConstant(by, dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
                    nArray[n2] = 2;
                    break;
                }
                case 12: {
                    this.table[n2] = new UnresolvedConstant(by, dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
                    nArray[n2] = 1;
                    break;
                }
                default: {
                    throw new ClassFileFormatException("Bad constant tag: " + by);
                }
            }
            ++n2;
        }
        n2 = 1;
        while (n2 < n) {
            if (nArray[n2] == 1) {
                this.table[n2] = ((UnresolvedConstant)this.table[n2]).resolveConstant(this.table);
            }
            ++n2;
        }
        n2 = 1;
        while (n2 < n) {
            if (nArray[n2] == 2) {
                this.table[n2] = ((UnresolvedConstant)this.table[n2]).resolveConstant(this.table);
            }
            ++n2;
        }
    }
}

