/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.InferenceNode;
import at.dms.backend.QTemporary;
import at.dms.backend.Trace;
import java.io.IOException;
import java.util.Vector;

public class TraceInferenceGraph
extends Trace {
    private static String[] COLORS = new String[]{"red", "green", "yellow", "magenta", "cyan", "white", "darkgrey", "darkblue", "darkred", "darkgreen", "darkyellow", "darkmagenta", "darkcyan", "gold", "lightgrey", "lightblue", "lightred", "lightgreen", "lightyellow", "lightmagenta", "lightcyan", "lilac", "turquoise", "aquamarine", "khaki", "purple", "yellowgreen", "pink", "orange", "orchid"};
    private InferenceNode[] nodes;

    public void run() {
        try {
            this.generateHeader();
            int n = 0;
            while (n < this.nodes.length) {
                this.trace(this.nodes[n]);
                ++n;
            }
            this.write("}");
            this.close();
        }
        catch (IOException iOException) {
            System.err.println("Cannot write infer.vcg");
        }
    }

    private void trace(InferenceNode inferenceNode) throws IOException {
        QTemporary[] qTemporaryArray = inferenceNode.getTemporaries();
        Vector vector = inferenceNode.getInferences();
        String string = "" + inferenceNode.getColor();
        string = string + " = ";
        int n = 0;
        while (n < qTemporaryArray.length) {
            string = string + qTemporaryArray[n] + (n == qTemporaryArray.length - 1 ? "" : ", ");
            ++n;
        }
        this.generateNode("" + inferenceNode, string, inferenceNode.getColor());
        n = 0;
        while (n < vector.size()) {
            InferenceNode inferenceNode2 = (InferenceNode)vector.elementAt(n);
            if (inferenceNode.getPosition() < inferenceNode2.getPosition()) {
                this.write(Trace.generateEdge("" + inferenceNode, "" + vector.elementAt(n), n, vector.size(), false));
            }
            ++n;
        }
    }

    private void generateNode(String string, String string2, int n) throws IOException {
        String string3 = n < COLORS.length ? COLORS[n] : COLORS[COLORS.length - 1];
        this.write("node: { title:\"" + string + "\" label: \"" + string2 + "\" color: " + string3 + "}");
    }

    private void generateHeader() throws IOException {
        this.write("graph: { title: \"CFG_GRAPH\"");
        this.write("x: 150");
        this.write("y: 30");
        this.write("width: 716");
        this.write("height: 960");
        this.write("layoutalgorithm: minbackward  ");
        this.write("display_edge_labels: yes");
        this.write("layout_nearfactor: 0");
        this.write("xspace: 25");
        this.write("node.color: lightyellow");
        this.write("node.textcolor: blue");
        this.write("edge.color: blue");
        this.write("edge.arrowsize: 15");
        this.write("edge.thickness: 1");
        this.write("stretch: 43");
        this.write("shrink: 100");
        this.write("classname 1 : \"CFG Edges (blue)\"");
        this.write("classname 2 : \"Const Lists (red)\"");
        this.write("classname 3 : \"Live Variable Lists (green)\"");
    }

    public TraceInferenceGraph(InferenceNode[] inferenceNodeArray) {
        super("infer.vcg");
        this.nodes = inferenceNodeArray;
    }
}

