/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BasicBlock;
import at.dms.backend.ControlFlow;
import at.dms.backend.QNode;
import at.dms.backend.Trace;
import java.io.IOException;

public class TraceControlFlow
extends Trace {
    private BasicBlock[] bblocks;
    private BasicBlock[] eblocks;

    public void run() {
        try {
            this.generateHeader();
            ControlFlow.setMarked(this.bblocks, false);
            this.trace(this.bblocks[0]);
            int n = 0;
            while (n < this.eblocks.length) {
                this.trace(this.eblocks[n]);
                ++n;
            }
            this.write("}");
            this.close();
        }
        catch (IOException iOException) {
            System.err.println("Cannot write trace.vcg");
        }
    }

    private void trace(BasicBlock basicBlock) throws IOException {
        if (basicBlock.isMarked()) {
            return;
        }
        basicBlock.setMarked(true);
        System.err.println("/------------------------\\ [" + basicBlock.getPosition() + "]");
        QNode[] qNodeArray = basicBlock.getQuadruples();
        String string = "";
        int n = 0;
        while (n < qNodeArray.length) {
            string = string + qNodeArray[n] + (n == qNodeArray.length - 1 ? "" : "\n");
            ++n;
        }
        System.err.print(string);
        this.generateBlock(basicBlock.getPosition(), string);
        System.err.println("\\------------------------/ [" + basicBlock.getPosition() + "]");
        BasicBlock[] basicBlockArray = basicBlock.getSuccessors();
        QNode[][] qNodeArray2 = basicBlock.getSuccessorAccess();
        int n2 = 0;
        while (n2 < basicBlockArray.length) {
            System.err.println("----> " + basicBlockArray[n2].getPosition());
            this.generateLink(basicBlock.getPosition(), basicBlockArray[n2].getPosition(), n2, basicBlockArray.length);
            int n3 = 0;
            while (qNodeArray2[n2] != null && n3 < qNodeArray2[n2].length) {
                System.err.println("  " + qNodeArray2[n2][n3]);
                ++n3;
            }
            ++n2;
        }
        if (basicBlockArray.length == 0) {
            this.write("edge: { sourcename:\"" + basicBlock.getPosition() + "\" targetname:\"end\" class: 1}");
        }
        System.err.println();
        n2 = 0;
        while (n2 < basicBlockArray.length) {
            this.trace(basicBlockArray[n2]);
            ++n2;
        }
    }

    private void generateBlock(int n, String string) throws IOException {
        this.write(Trace.generateNode("" + n, string));
    }

    private void generateLink(int n, int n2, int n3, int n4) throws IOException {
        this.write(Trace.generateEdge("" + n, "" + n2, n3, n4, true));
    }

    private void generateHeader() throws IOException {
        this.write("graph: { title: \"CFG_GRAPH\"");
        this.write("x: 150");
        this.write("y: 30");
        this.write("width: 716");
        this.write("height: 960");
        this.write("layoutalgorithm: minbackward  ");
        this.write("display_edge_labels: yes");
        this.write("manhatten_edges: yes");
        this.write("layout_nearfactor: 0");
        this.write("xspace: 25");
        this.write("node.color: lightyellow");
        this.write("node.textcolor: blue");
        this.write("edge.color: blue");
        this.write("edge.arrowsize: 15");
        this.write("edge.thickness: 4");
        this.write("stretch: 43");
        this.write("shrink: 100");
        this.write("classname 1 : \"CFG Edges (blue)\"");
        this.write("classname 2 : \"Const Lists (red)\"");
        this.write("classname 3 : \"Live Variable Lists (green)\"");
        this.write("node: { title:\"begin\" label: \"Start\" shape: ellipse color: aquamarine }");
        this.write("node: { title:\"end\" label: \"End\" shape: ellipse color: aquamarine }");
        this.write("edge: { sourcename:\"begin\" targetname:\"0\" class: 1}");
    }

    public TraceControlFlow(BasicBlock[] basicBlockArray, BasicBlock[] basicBlockArray2) {
        super("trace.vcg");
        this.bblocks = basicBlockArray;
        this.eblocks = basicBlockArray2;
    }
}

