/*
 * Decompiled with CFR 0.152.
 */
package at.dms.backend;

import at.dms.backend.BasicBlock;
import at.dms.backend.InstructionHandle;
import at.dms.backend.QNode;
import at.dms.backend.QQuadruple;
import at.dms.classfile.Instruction;
import at.dms.classfile.JumpInstruction;
import java.util.Stack;

public class CodeSequence {
    private InstructionHandle codeStart;
    private InstructionHandle current;
    private int max = Integer.MAX_VALUE;
    private Stack stack = new Stack();

    public InstructionHandle getCodeStart() {
        return this.codeStart;
    }

    public InstructionHandle getCurrent() {
        return this.current;
    }

    public void plantInstruction(InstructionHandle instructionHandle) {
        if (this.current != null) {
            this.current.setNext(instructionHandle);
        }
        this.current = instructionHandle;
        instructionHandle.getInstruction().dump();
        if (this.codeStart == null) {
            this.codeStart = this.current;
        }
    }

    public void plantInstruction(Instruction instruction) {
        this.plantInstruction(new InstructionHandle(instruction, this.current));
    }

    public void plantQuadruple(QNode qNode) {
        qNode.generate(this);
    }

    public void jumpToBasicBlock(BasicBlock basicBlock) {
        if (basicBlock.isMarked() || basicBlock.getPosition() >= this.max) {
            this.plantInstruction(new InstructionHandle(new JumpInstruction(167, basicBlock), this.current));
        }
        this.plantBasicBlock(basicBlock);
    }

    public void plantBasicBlock(BasicBlock basicBlock) {
        if (!basicBlock.isMarked()) {
            if (basicBlock.getPosition() >= this.max) {
                this.stack.push(basicBlock);
            } else {
                basicBlock.generateQuadruple(this);
            }
        }
    }

    public void plantBasicBlock(BasicBlock basicBlock, JumpInstruction jumpInstruction, QQuadruple[] qQuadrupleArray) {
        if (qQuadrupleArray != null && qQuadrupleArray.length != 0) {
            BasicBlock basicBlock2 = new BasicBlock(-1);
            basicBlock2.setBody(qQuadrupleArray);
            jumpInstruction.setTarget(basicBlock2);
            this.plantBasicBlock(basicBlock2);
            this.jumpToBasicBlock(basicBlock);
        } else {
            this.plantBasicBlock(basicBlock);
        }
    }

    public void plantBasicBlock(BasicBlock basicBlock, int n) {
        int n2 = this.max;
        this.max = n;
        this.plantBasicBlock(basicBlock);
        this.max = n2;
    }

    public void close() {
        if (this.stack.size() > 0) {
            Stack stack = this.stack;
            this.stack = new Stack();
            while (stack.size() > 0) {
                BasicBlock basicBlock = (BasicBlock)stack.pop();
                if (basicBlock.isMarked()) continue;
                this.plantBasicBlock(basicBlock);
            }
            this.close();
        }
    }
}

