/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import kaffe.io.CharToByteConverter;

public class CharToByteEUC_JP
extends CharToByteConverter {
    private static final boolean US_ASCII = true;
    static boolean tableLoaded = false;
    static char[] utable;
    static byte[] e1table;
    static byte[] e2table;
    static String encodingRoot;

    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) {
        if (!tableLoaded) {
            CharToByteEUC_JP.loadTable();
        }
        int n5 = n3;
        int n6 = n3 + n4;
        int n7 = n;
        int n8 = n + n2;
        while (n7 < n8) {
            char c = cArray[n7];
            if (c < '\u0080') {
                if (n5 >= n6 || n5 >= n6) break;
                byArray[n5++] = (byte)c;
            } else {
                int n9 = Arrays.binarySearch(utable, c);
                if (n9 >= 0) {
                    byte by = e1table[n9];
                    byte by2 = e2table[n9];
                    if (by > 0) {
                        if (n5 + 2 >= n6) break;
                        byArray[n5++] = -113;
                        byArray[n5++] = (byte)(by | 0x80);
                        byArray[n5++] = (byte)(by2 | 0x80);
                    } else {
                        if (n5 + 1 >= n6) break;
                        byArray[n5++] = by;
                        byArray[n5++] = by2;
                    }
                } else {
                    if (n5 >= n6) break;
                    byArray[n5++] = 63;
                }
            }
            ++n7;
        }
        if (n8 > n7) {
            this.carry(cArray, n7, n8 - n7);
        }
        return n5 - n3;
    }

    public int getNumberOfBytes(char[] cArray, int n, int n2) {
        return n2;
    }

    private static final void loadTable() {
        try {
            String string = encodingRoot + ".CharToByteEUC_JP";
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(string.replace('.', '/') + ".tbl");
            if (inputStream != null) {
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                utable = (char[])objectInputStream.readObject();
                e1table = (byte[])objectInputStream.readObject();
                e2table = (byte[])objectInputStream.readObject();
                tableLoaded = true;
            }
        }
        catch (Exception exception) {
            System.err.println("CharToByteEUC_JP.tbl could not be loaded" + exception);
        }
        if (!tableLoaded) {
            utable = new char[0];
            e1table = new byte[0];
            e2table = new byte[0];
            tableLoaded = true;
            System.err.println("CharToByteEUC_JP.tbl could not be loaded");
        }
    }

    static {
        encodingRoot = "kaffe.io";
    }
}

