/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.MissingResourceException;

public final class Locale
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9149081749638150636L;
    public static final Locale ENGLISH = new Locale("en", null);
    public static final Locale FRENCH = new Locale("fr", null);
    public static final Locale GERMAN = new Locale("de", null);
    public static final Locale ITALIAN = new Locale("it", null);
    public static final Locale JAPANESE = new Locale("ja", null);
    public static final Locale KOREAN = new Locale("ko", null);
    public static final Locale CHINESE = new Locale("zh", null);
    public static final Locale SIMPLIFIED_CHINESE = new Locale("zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW");
    public static final Locale FRANCE = new Locale("fr", "FR");
    public static final Locale GERMANY = new Locale("de", "DE");
    public static final Locale ITALY = new Locale("it", "IT");
    public static final Locale JAPAN = new Locale("ja", "JP");
    public static final Locale KOREA = new Locale("ko", "KR");
    public static final Locale CHINA = new Locale("zh", "CN");
    public static final Locale PRC = new Locale("zh", "CN");
    public static final Locale TAIWAN = new Locale("zh", "TW");
    public static final Locale UK = new Locale("en", "GB");
    public static final Locale US = new Locale("en", "US");
    public static final Locale CANADA = new Locale("en", "CA");
    public static final Locale CANADA_FRENCH = new Locale("fr", "CA");
    private static Locale defaultLocale;
    private String lang;
    private String cntry;
    private String var;
    private int hashcode;

    private static final String toLowerCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toLowerCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    private static final String toUpperCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toUpperCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    public final Object clone() {
        return new Locale(this.lang, this.cntry, this.var);
    }

    public final boolean equals(Object object) {
        if (object instanceof Locale) {
            Locale locale2 = (Locale)object;
            if (!(this.lang != locale2.lang && !this.lang.equals(locale2.lang) || this.cntry != locale2.cntry && !this.cntry.equals(locale2.cntry) || this.var != locale2.var && !this.var.equals(locale2.var))) {
                return true;
            }
        }
        return false;
    }

    public final String getCountry() {
        return this.cntry;
    }

    public static final synchronized Locale getDefault() {
        return defaultLocale;
    }

    public final String getDisplayCountry() {
        return this.cntry;
    }

    public final String getDisplayCountry(Locale locale2) {
        return this.cntry;
    }

    public final String getDisplayLanguage() {
        return this.lang;
    }

    public final String getDisplayLanguage(Locale locale2) {
        return this.lang;
    }

    public final String getDisplayName() {
        return this.toString();
    }

    public final String getDisplayName(Locale locale2) {
        return this.toString();
    }

    public final String getDisplayVariant() {
        return this.var;
    }

    public final String getDisplayVariant(Locale locale2) {
        return this.var;
    }

    public final String getISO3Country() throws MissingResourceException {
        throw new MissingResourceException("ISO3 not supported", "Locale", "");
    }

    public final String getISO3Language() throws MissingResourceException {
        throw new MissingResourceException("ISO3 not supported", "Locale", "");
    }

    public final String getLanguage() {
        return this.lang;
    }

    public final String getVariant() {
        return this.var;
    }

    public final synchronized int hashCode() {
        return this.hashcode;
    }

    public static final synchronized void setDefault(Locale locale2) {
        defaultLocale = locale2;
    }

    public final String toString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = this.lang.length() > 0;
        boolean bl3 = this.cntry.length() > 0;
        boolean bl4 = bl = this.var.length() > 0;
        if (bl2) {
            stringBuffer.append(this.lang);
        }
        if (bl3) {
            stringBuffer.append('_');
            stringBuffer.append(this.cntry);
        } else if (bl2 && bl) {
            stringBuffer.append('_');
        }
        if (bl && (bl2 || bl3)) {
            stringBuffer.append('_');
            stringBuffer.append(this.var);
        }
        return new String(stringBuffer);
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public Locale(String string, String string2, String string3) {
        this.lang = string != null ? Locale.toLowerCase(string) : "";
        this.cntry = string2 != null ? Locale.toUpperCase(string2) : "";
        this.var = string3 != null ? Locale.toUpperCase(string3) : "";
        this.hashcode = this.lang.hashCode() ^ this.cntry.hashCode() ^ this.var.hashCode();
    }

    static {
        String string = System.getProperty("user.language", "en");
        String string2 = System.getProperty("user.region", "US");
        String string3 = "";
        int n = string2.indexOf(95);
        if (n != -1) {
            string3 = string2.substring(n + 1);
            string2 = string2.substring(n);
        }
        defaultLocale = new Locale(string, string2, string3);
    }
}

