/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedListIterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    Elem head = null;
    Elem tail = null;
    int length = 0;

    public Object getFirst() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.head.o;
    }

    public Object getLast() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.tail.o;
    }

    public Object removeFirst() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        Object object = this.head.o;
        this.head = this.head.next;
        if (this.head == null) {
            this.tail = null;
        } else {
            this.head.prev = null;
        }
        --this.length;
        return object;
    }

    public Object removeLast() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        Object object = this.tail.o;
        this.tail = this.tail.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        --this.length;
        return object;
    }

    public void addFirst(Object object) {
        Elem elem = new Elem(object);
        ++this.modCount;
        if (this.length == 0) {
            this.head = this.tail = elem;
        } else {
            elem.next = this.head;
            this.head.prev = elem;
            this.head = elem;
        }
        ++this.length;
    }

    public void addLast(Object object) {
        Elem elem = new Elem(object);
        ++this.modCount;
        if (this.length == 0) {
            this.head = this.tail = elem;
        } else {
            elem.prev = this.tail;
            this.tail.next = elem;
            this.tail = elem;
        }
        ++this.length;
    }

    public boolean contains(Object object) {
        return this.findObject(object) != null;
    }

    public int size() {
        return this.length;
    }

    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    public boolean remove(Object object) {
        Elem elem = this.findObject(object);
        if (elem != null) {
            this.remove(elem);
            return true;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(0, collection);
    }

    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.length) {
            throw new IndexOutOfBoundsException();
        }
        LinkedList linkedList = new LinkedList(collection);
        if (linkedList.length == 0) {
            return false;
        }
        Elem elem = this.head;
        while (n-- > 0) {
            elem = elem.next;
        }
        Elem elem2 = elem == null ? null : elem.next;
        ++this.modCount;
        linkedList.head.prev = elem;
        linkedList.tail.next = elem2;
        if (elem == null) {
            this.head = linkedList.head;
        } else {
            elem.next = linkedList.head;
        }
        if (elem2 == null) {
            this.tail = linkedList.tail;
        } else {
            elem2.prev = linkedList.tail;
        }
        this.length += linkedList.length;
        return true;
    }

    public void clear() {
        ++this.modCount;
        this.head = null;
        this.tail = null;
        this.length = 0;
    }

    public Object get(int n) {
        return this.findIndex((int)n).o;
    }

    public Object set(int n, Object object) {
        Elem elem = this.findIndex(n);
        Object object2 = elem.o;
        elem.o = object;
        return object2;
    }

    public void add(int n, Object object) {
        if (n == this.length) {
            this.addLast(object);
            return;
        }
        Elem elem = this.findIndex(n);
        Elem elem2 = new Elem(object);
        ++this.modCount;
        elem2.prev = elem.prev;
        elem2.next = elem;
        elem.prev = elem2;
        if (elem2.prev == null) {
            this.head = elem2;
        } else {
            elem2.prev.next = elem2;
        }
        ++this.length;
    }

    public Object remove(int n) {
        Elem elem = this.findIndex(n);
        Object object = elem.o;
        this.remove(elem);
        return object;
    }

    public int indexOf(Object object) {
        int n = 0;
        Elem elem = this.head;
        while (elem != null) {
            boolean bl = object == null ? elem.o == null : object.equals(elem.o);
            if (bl) {
                return n;
            }
            elem = elem.next;
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.length - 1;
        Elem elem = this.tail;
        while (elem != null) {
            boolean bl = object == null ? elem.o == null : object.equals(elem.o);
            if (bl) {
                return n;
            }
            elem = elem.prev;
            --n;
        }
        return -1;
    }

    public ListIterator listIterator(int n) {
        return new LinkedListIterator(this, n);
    }

    public Object clone() {
        LinkedList linkedList;
        try {
            linkedList = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        linkedList.clear();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            linkedList.addLast(iterator.next());
        }
        return linkedList;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        int n = 0;
        Elem elem = this.head;
        while (elem != null) {
            objectArray[n++] = elem.o;
            elem = elem.next;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.length);
        }
        int n = 0;
        Elem elem = this.head;
        while (elem != null) {
            objectArray[n++] = elem.o;
            elem = elem.next;
        }
        if (objectArray.length > this.length) {
            objectArray[this.length] = null;
        }
        return objectArray;
    }

    private final Elem findObject(Object object) {
        Elem elem = this.head;
        while (elem != null) {
            boolean bl = object == null ? elem.o == null : object.equals(elem.o);
            if (bl) {
                return elem;
            }
            elem = elem.next;
        }
        return null;
    }

    private final Elem findIndex(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        Elem elem = this.head;
        while (n-- > 0) {
            elem = elem.next;
        }
        return elem;
    }

    void add(Elem elem, Object object) {
        if (elem == null) {
            this.addLast(object);
            return;
        }
        Elem elem2 = new Elem(object);
        ++this.modCount;
        elem2.prev = elem.prev;
        elem2.next = elem;
        elem.prev = elem2;
        if (elem2.prev == null) {
            this.head = elem2;
        } else {
            elem2.prev.next = elem2;
        }
        ++this.length;
    }

    Elem remove(Elem elem) {
        if (elem.prev == null) {
            this.removeFirst();
            return this.head;
        }
        if (elem.next == null) {
            this.removeLast();
            return null;
        }
        ++this.modCount;
        elem.prev.next = elem.next;
        elem.next.prev = elem.prev;
        --this.length;
        return elem.next;
    }

    public LinkedList() {
    }

    public LinkedList(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addLast(iterator.next());
        }
    }

    static class Elem {
        public Object o;
        public Elem prev;
        public Elem next;

        Elem(Object object) {
            this.o = object;
            this.prev = null;
            this.next = null;
        }
    }
}

