/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7997698588986878753L;
    private long[] bits;

    private static final int bitOffset(int n) {
        return n >> 6;
    }

    private static final long bitMask(int n) {
        return 1L << (n & 0x3F);
    }

    private final void ensureSize(int n) {
        int n2 = BitSet.bitOffset(n + 63);
        if (n2 > this.bits.length) {
            if (n2 < 2 * this.bits.length) {
                n2 = 2 * this.bits.length;
            }
            long[] lArray = new long[n2];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            this.bits = lArray;
        }
    }

    public synchronized void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(n + 1);
        int n2 = BitSet.bitOffset(n);
        this.bits[n2] = this.bits[n2] | BitSet.bitMask(n);
    }

    public synchronized void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(n + 1);
        int n2 = BitSet.bitOffset(n);
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(n) ^ -1L);
    }

    public synchronized boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = BitSet.bitOffset(n);
        if (n2 < this.bits.length) {
            return (this.bits[n2] & BitSet.bitMask(n)) != 0L;
        }
        return false;
    }

    public synchronized int length() {
        long[] lArray = this.bits;
        int n = lArray.length - 1;
        while (n >= 0 && lArray[n] == 0L) {
            --n;
        }
        if (n < 0) {
            return 0;
        }
        long l = lArray[n];
        long l2 = Long.MIN_VALUE;
        n = n + 1 << 6;
        while ((l & l2) == 0L) {
            --n;
            l2 >>= 1;
        }
        return n;
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean equals(Object object) {
        Object object2;
        Object object3;
        if (object == this) {
            return true;
        }
        if (!(object instanceof BitSet)) {
            return false;
        }
        if (System.identityHashCode(this) < System.identityHashCode(object)) {
            object3 = this;
            object2 = object;
        } else {
            object3 = object;
            object2 = this;
        }
        Object object4 = object3;
        synchronized (object4) {
            Object object5 = object2;
            synchronized (object5) {
                int n;
                long[] lArray = this.bits;
                long[] lArray2 = ((BitSet)object).bits;
                int n2 = n = Math.min(lArray.length, lArray2.length);
                while (n2-- > 0) {
                    if (lArray[n2] == lArray2[n2]) continue;
                    return false;
                }
                if (n != lArray2.length) {
                    lArray = lArray2;
                } else if (n == lArray.length) {
                    return true;
                }
                n2 = lArray.length;
                while (n2-- > n) {
                    if (lArray[n2] == 0L) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public void and(BitSet bitSet) {
        BitSet bitSet2;
        BitSet bitSet3;
        if (this == bitSet) {
            return;
        }
        if (System.identityHashCode(this) < System.identityHashCode(bitSet)) {
            bitSet3 = this;
            bitSet2 = bitSet;
        } else {
            bitSet3 = bitSet;
            bitSet2 = this;
        }
        BitSet bitSet4 = bitSet3;
        synchronized (bitSet4) {
            BitSet bitSet5 = bitSet2;
            synchronized (bitSet5) {
                int n;
                long[] lArray = this.bits;
                long[] lArray2 = bitSet.bits;
                int n2 = n = Math.min(lArray.length, lArray2.length);
                while (n2-- > 0) {
                    int n3 = n2;
                    lArray[n3] = lArray[n3] & lArray2[n2];
                }
                n2 = lArray.length;
                while (n2-- > n) {
                    lArray[n2] = 0L;
                }
            }
        }
    }

    public void andNot(BitSet bitSet) {
        BitSet bitSet2;
        BitSet bitSet3;
        if (this == bitSet) {
            BitSet bitSet4 = this;
            synchronized (bitSet4) {
                long[] lArray = this.bits;
                int n = lArray.length;
                while (n-- > 0) {
                    lArray[n] = 0L;
                }
            }
            return;
        }
        if (System.identityHashCode(this) < System.identityHashCode(bitSet)) {
            bitSet3 = this;
            bitSet2 = bitSet;
        } else {
            bitSet3 = bitSet;
            bitSet2 = this;
        }
        BitSet bitSet5 = bitSet3;
        synchronized (bitSet5) {
            BitSet bitSet6 = bitSet2;
            synchronized (bitSet6) {
                int n;
                long[] lArray = this.bits;
                long[] lArray2 = bitSet.bits;
                int n2 = n = Math.min(lArray.length, lArray2.length);
                while (n2-- > 0) {
                    int n3 = n2;
                    lArray[n3] = lArray[n3] & (lArray2[n2] ^ -1L);
                }
            }
        }
    }

    public void or(BitSet bitSet) {
        BitSet bitSet2;
        BitSet bitSet3;
        if (this == bitSet) {
            return;
        }
        if (System.identityHashCode(this) < System.identityHashCode(bitSet)) {
            bitSet3 = this;
            bitSet2 = bitSet;
        } else {
            bitSet3 = bitSet;
            bitSet2 = this;
        }
        BitSet bitSet4 = bitSet3;
        synchronized (bitSet4) {
            BitSet bitSet5 = bitSet2;
            synchronized (bitSet5) {
                int n;
                long[] lArray = this.bits;
                long[] lArray2 = bitSet.bits;
                int n2 = n = Math.min(lArray.length, lArray2.length);
                while (n2-- > 0) {
                    int n3 = n2;
                    lArray[n3] = lArray[n3] | lArray2[n2];
                }
                if (lArray.length < lArray2.length) {
                    this.ensureSize(bitSet.length());
                    lArray = this.bits;
                    n2 = this.bits.length;
                    while (n2-- > n) {
                        lArray[n2] = lArray2[n2];
                    }
                }
            }
        }
    }

    public void xor(BitSet bitSet) {
        BitSet bitSet2;
        BitSet bitSet3;
        if (this == bitSet) {
            BitSet bitSet4 = this;
            synchronized (bitSet4) {
                long[] lArray = this.bits;
                int n = lArray.length;
                while (n-- > 0) {
                    lArray[n] = 0L;
                }
            }
            return;
        }
        if (System.identityHashCode(this) < System.identityHashCode(bitSet)) {
            bitSet3 = this;
            bitSet2 = bitSet;
        } else {
            bitSet3 = bitSet;
            bitSet2 = this;
        }
        BitSet bitSet5 = bitSet3;
        synchronized (bitSet5) {
            BitSet bitSet6 = bitSet2;
            synchronized (bitSet6) {
                int n;
                long[] lArray = this.bits;
                long[] lArray2 = bitSet.bits;
                int n2 = n = Math.min(lArray.length, lArray2.length);
                while (n2-- > 0) {
                    int n3 = n2;
                    lArray[n3] = lArray[n3] ^ lArray2[n2];
                }
                if (lArray.length < lArray2.length) {
                    this.ensureSize(bitSet.length());
                    lArray = this.bits;
                    n2 = this.bits.length;
                    while (n2-- > n) {
                        lArray[n2] = lArray2[n2];
                    }
                }
            }
        }
    }

    public synchronized int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public synchronized Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        bitSet.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bitSet.bits, 0, bitSet.bits.length);
        return bitSet;
    }

    public synchronized String toString() {
        int n = this.length();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n2 = 0;
        while (n2 < n) {
            if (this.get(n2)) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append(n2);
            }
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        this.bits = new long[BitSet.bitOffset(n + 63)];
    }
}

