/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class SimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 4774881970558875024L;
    private static final String DEFAULTPATTERNCHARS = "GyMdkHmsSEDFwWahKz";
    private static String NUMERIC_PATTERN = "ydhHmsSDFwWkK";
    private static int[] NUMERIC_FIELD = new int[]{2, 1, 5, 10, 11, 12, 13, 14, 6, 8, 3, 8, 11, 10};
    private DateFormatSymbols syms;
    private String pattern;

    private static final String getDefaultPattern(Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("dateformat", locale2);
        String string = ((String[])resourceBundle.getObject("date"))[2];
        String string2 = ((String[])resourceBundle.getObject("time"))[2];
        return string + " " + string2;
    }

    public void applyLocalizedPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.syms.getLocalPatternChars();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = string2.indexOf(c);
            if (n2 >= 0) {
                stringBuffer.append(DEFAULTPATTERNCHARS.charAt(n2));
            } else {
                stringBuffer.append(c);
                if (c == '\'') {
                    do {
                        c = string.charAt(++n);
                        stringBuffer.append(c);
                    } while (c != '\'');
                }
            }
            ++n;
        }
        this.pattern = stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.pattern = string;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        char[] cArray = this.pattern.toCharArray();
        int n = 0;
        block21: while (n < cArray.length) {
            int n2 = 0;
            char c = cArray[n];
            ++n;
            if (c != '\'') {
                ++n2;
                while (n < cArray.length && cArray[n] == c) {
                    ++n2;
                    ++n;
                }
            }
            int n3 = stringBuffer.length();
            block0 : switch (c) {
                case 'G': {
                    int n4 = this.calendar.get(0);
                    stringBuffer.append(this.syms.eras[n4]);
                    if (fieldPosition.field != 0) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'y': {
                    int n4 = this.calendar.get(1);
                    if (n2 < 4 && (n4 %= 100) < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 1) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'M': {
                    int n4 = this.calendar.get(2);
                    if (n2 < 3) {
                        if (++n4 < 10 && n2 == 2) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(n4);
                    } else if (n2 == 3) {
                        stringBuffer.append(this.syms.shortMonths[n4]);
                    } else {
                        stringBuffer.append(this.syms.months[n4]);
                    }
                    if (fieldPosition.field != 2) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'd': {
                    int n4 = this.calendar.get(5);
                    if (n2 > 1 && n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 3) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'k': {
                    int n4 = this.calendar.get(11);
                    if (n4 == 0) {
                        n4 = 24;
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 4) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'H': {
                    int n4 = this.calendar.get(11);
                    if (n2 > 1 && n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 5) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'm': {
                    int n4 = this.calendar.get(12);
                    if (n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 6) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 's': {
                    int n4 = this.calendar.get(13);
                    if (n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 7) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'S': {
                    int n4 = this.calendar.get(14);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 8) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'E': {
                    int n4 = this.calendar.get(7);
                    if (n2 < 4) {
                        stringBuffer.append(this.syms.shortWeekdays[n4]);
                    } else {
                        stringBuffer.append(this.syms.weekdays[n4]);
                    }
                    if (fieldPosition.field != 9) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'D': {
                    int n4 = this.calendar.get(6);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 10) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'F': {
                    int n4 = this.calendar.get(8);
                    stringBuffer.append(n4);
                    break;
                }
                case 'w': {
                    int n4 = this.calendar.get(3);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 12) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'W': {
                    int n4 = this.calendar.get(4);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 13) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'a': {
                    int n4 = this.calendar.get(9);
                    stringBuffer.append(this.syms.amPmStrings[n4]);
                    if (fieldPosition.field != 14) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'h': {
                    int n4 = this.calendar.get(10);
                    if (n4 == 0) {
                        n4 = 12;
                    }
                    if (n2 > 1 && n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 15) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'K': {
                    int n4 = this.calendar.get(10);
                    stringBuffer.append(n4);
                    if (fieldPosition.field != 16) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case 'z': {
                    TimeZone timeZone = this.calendar.getTimeZone();
                    String string = timeZone.getID();
                    boolean bl = timeZone.inDaylightTime(date);
                    int n5 = 0;
                    while (n5 < this.syms.zoneStrings.length) {
                        String[] stringArray = this.syms.zoneStrings[n5];
                        if (!string.equals(stringArray[0])) {
                            ++n5;
                            continue;
                        }
                        if (n2 < 4) {
                            if (bl) {
                                stringBuffer.append(stringArray[4]);
                                break;
                            }
                            stringBuffer.append(stringArray[2]);
                            break;
                        }
                        if (bl) {
                            stringBuffer.append(stringArray[3]);
                            break;
                        }
                        stringBuffer.append(stringArray[1]);
                        break;
                    }
                    if (n5 == this.syms.zoneStrings.length) {
                        stringBuffer.append("GMT");
                        int n6 = timeZone.getOffset(this.calendar.get(0), this.calendar.get(1), this.calendar.get(2), this.calendar.get(5), this.calendar.get(7), this.calendar.get(14)) / 60000;
                        if (n6 < 0) {
                            n6 = Math.abs(n6);
                            stringBuffer.append("-");
                        } else {
                            stringBuffer.append("+");
                        }
                        stringBuffer.append(n6 / 60);
                        stringBuffer.append(":");
                        if (n6 % 60 < 10) {
                            stringBuffer.append("0");
                        }
                        stringBuffer.append(n6 % 60);
                    }
                    if (fieldPosition.field != 17) continue block21;
                    fieldPosition.begin = n3;
                    fieldPosition.end = stringBuffer.length();
                    break;
                }
                case '\'': {
                    if (cArray[n] == '\'') {
                        stringBuffer.append('\'');
                        ++n;
                        break;
                    }
                    while (true) {
                        if (cArray[n] == '\'') {
                            ++n;
                            break block0;
                        }
                        stringBuffer.append(cArray[n]);
                        ++n;
                    }
                }
                default: {
                    int n5 = 0;
                    while (n5 < n2) {
                        stringBuffer.append(c);
                        ++n5;
                    }
                    continue block21;
                }
            }
        }
        return stringBuffer;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.syms;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * Unable to fully structure code
     */
    public Date parse(String var1_1, ParsePosition var2_2) {
        this.calendar.clear();
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setGroupingUsed(false);
        var2_2.setErrorIndex(-1);
        var4_4 = var3_3 = var2_2.getIndex();
        var5_5 = var1_1.length();
        var6_6 = false;
        var7_7 = this.pattern.toCharArray();
        var8_8 = 0;
        while (var8_8 < var7_7.length) {
            block32: {
                if ((var9_9 = var7_7[var8_8++]) != 39) break block32;
                if (var8_8 >= var7_7.length || var7_7[var8_8] != '\'') ** GOTO lbl26
                if (var4_4 >= var5_5 || var1_1.charAt(var4_4) != '\'') {
                    var2_2.setIndex(var3_3);
                    var2_2.setErrorIndex(var4_4);
                    return null;
                }
                ++var4_4;
                ++var8_8;
                continue;
lbl-1000:
                // 1 sources

                {
                    if (var4_4 >= var5_5 || var1_1.charAt(var4_4) != var7_7[var8_8]) {
                        var2_2.setIndex(var3_3);
                        var2_2.setErrorIndex(var4_4);
                        return null;
                    }
                    ++var4_4;
                    ++var8_8;
lbl26:
                    // 2 sources

                    ** while (var8_8 < var7_7.length && var7_7[var8_8] != '\'')
                }
lbl27:
                // 1 sources

                ++var8_8;
                continue;
            }
            if (var9_9 >= 97 && var9_9 <= 122 || var9_9 >= 65 && var9_9 <= 90) {
                var10_10 = 1;
                var11_11 = -1;
                while (var8_8 < var7_7.length && var7_7[var8_8] == var9_9) {
                    ++var10_10;
                    ++var8_8;
                }
                while (true) {
                    if (var4_4 >= var5_5) {
                        var2_2.setIndex(var3_3);
                        var2_2.setErrorIndex(var4_4);
                        return null;
                    }
                    var12_12 = var1_1.charAt(var4_4);
                    if (var12_12 != ' ' && var12_12 != '\t') break;
                    ++var4_4;
                }
                var2_2.setIndex(var4_4);
                if (SimpleDateFormat.NUMERIC_PATTERN.indexOf(var9_9) != -1 || var9_9 == 77 && var10_10 <= 2) {
                    if (var8_8 < var7_7.length && "GyMdkHmsSEDFwWahKz".indexOf(var7_7[var8_8]) != -1) {
                        if (var4_4 + var10_10 > var5_5) {
                            var2_2.setIndex(var3_3);
                            var2_2.setErrorIndex(var4_4);
                            return null;
                        }
                        var12_13 = this.numberFormat.parse(var1_1.substring(0, var4_4 + var10_10), var2_2);
                    } else {
                        var12_13 = this.numberFormat.parse(var1_1, var2_2);
                    }
                    if (var12_13 == null) {
                        var2_2.setIndex(var3_3);
                        var2_2.setErrorIndex(var4_4);
                        return null;
                    }
                    var11_11 = var12_13.intValue();
                    switch (var9_9) {
                        case 121: {
                            var6_6 = var10_10 < 3 && var11_11 >= 0 && var2_2.getIndex() - var4_4 <= 2;
                            break;
                        }
                        case 77: {
                            --var11_11;
                            break;
                        }
                        case 107: {
                            if (var11_11 != 24) break;
                            var11_11 = 0;
                            break;
                        }
                        case 104: {
                            if (var11_11 != 12) break;
                            var11_11 = 0;
                            break;
                        }
                    }
                    this.calendar.set(SimpleDateFormat.NUMERIC_FIELD[SimpleDateFormat.NUMERIC_PATTERN.indexOf(var9_9) + 1], var11_11);
                    var4_4 = var2_2.getIndex();
                    continue;
                }
                switch (var9_9) {
                    case 71: {
                        var4_4 = this.parseField(var1_1, var4_4, 0, this.syms.eras);
                        break;
                    }
                    case 77: {
                        var4_4 = this.parseField(var1_1, var4_4, 2, this.syms.months);
                        if (var4_4 > 0) break;
                        var4_4 = this.parseField(var1_1, -var4_4, 2, this.syms.shortMonths);
                        break;
                    }
                    case 69: {
                        var4_4 = this.parseField(var1_1, var4_4, 7, this.syms.weekdays);
                        if (var4_4 > 0) break;
                        var4_4 = this.parseField(var1_1, -var4_4, 7, this.syms.shortWeekdays);
                        break;
                    }
                    case 97: {
                        var4_4 = this.parseField(var1_1, var4_4, 9, this.syms.amPmStrings);
                        break;
                    }
                    case 122: {
                        var4_4 = this.parseTimeZone(var1_1, var4_4, var5_5);
                        break;
                    }
                    default: {
                        var4_4 = -var4_4;
                    }
                }
                if (var4_4 <= 0) {
                    var2_2.setIndex(var3_3);
                    var2_2.setErrorIndex(-var4_4);
                    return null;
                }
                var2_2.setIndex(var4_4);
                continue;
            }
            if (var4_4 >= var5_5 || var1_1.charAt(var4_4) != var9_9) {
                var2_2.setIndex(var3_3);
                var2_2.setErrorIndex(var4_4);
                return null;
            }
            ++var4_4;
        }
        if (var6_6 && this.calendar.isSet(1)) {
            var8_8 = Calendar.getInstance().get(1);
            var9_9 = var8_8 - var8_8 % 100;
            var10_10 = var9_9 + this.calendar.get(1);
            if (var10_10 > var8_8 + 20) {
                var10_10 -= 100;
            } else if (var10_10 < var8_8 - 80) {
                var10_10 += 100;
            }
            this.calendar.set(1, var10_10);
        }
        var2_2.setIndex(var4_4);
        return this.calendar.getTime();
    }

    private final int parseField(String string, int n, int n2, String[] stringArray) {
        int n3 = -1;
        int n4 = 0;
        int n5 = stringArray.length;
        while (n5-- > 0) {
            int n6 = stringArray[n5].length();
            if (n6 <= n4 || !string.regionMatches(true, n, stringArray[n5], 0, n6)) continue;
            n3 = n5;
            n4 = n6;
        }
        if (n3 >= 0) {
            this.calendar.set(n2, n3);
            return n + n4;
        }
        return -n;
    }

    private final int parseTimeZone(String string, int n, int n2) {
        int n3;
        Object object;
        this.calendar.set(16, 0);
        if (string.regionMatches(n, "GMT", 0, 3)) {
            int n4 = n + 3;
            int n5 = 0;
            if (n4 < n2) {
                switch (string.charAt(n4)) {
                    case '+': {
                        n5 = 1;
                        break;
                    }
                    case '-': {
                        n5 = -1;
                    }
                }
            }
            if (n5 == 0) {
                this.calendar.set(15, 0);
                return n4;
            }
            ParsePosition parsePosition = new ParsePosition(n4 + 1);
            Number number = this.numberFormat.parse(string, parsePosition);
            if (number == null) {
                return -n;
            }
            int n6 = number.intValue();
            if (parsePosition.getIndex() < n2 && string.charAt(parsePosition.getIndex()) == ':') {
                n6 *= 60;
                parsePosition.setIndex(parsePosition.getIndex() + 1);
                number = this.numberFormat.parse(string, parsePosition);
                if (number == null) {
                    return -n;
                }
                n6 += number.intValue();
            } else {
                n6 = n6 < 24 ? (n6 *= 60) : n6 / 100 * 60 + n6 % 100;
            }
            n6 *= 60000;
            if (n5 == -1) {
                n6 = -n6;
            }
            this.calendar.set(15, n6);
            return parsePosition.getIndex();
        }
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < this.syms.zoneStrings.length) {
            object = this.syms.zoneStrings[n10];
            int n11 = 1;
            while (n11 <= 4) {
                n3 = object[n11].length();
                if (n3 > n8 && string.regionMatches(true, n, object[n11], 0, n3)) {
                    n7 = n10;
                    n9 = n11;
                    n8 = n3;
                }
                ++n11;
            }
            ++n10;
        }
        if (n7 != -1) {
            TimeZone timeZone = TimeZone.getTimeZone(this.syms.zoneStrings[n7][0]);
            this.calendar.set(15, timeZone.getRawOffset());
            return n + n8;
        }
        DecimalFormat decimalFormat = new DecimalFormat("+####;-####");
        decimalFormat.setParseIntegerOnly(true);
        decimalFormat.setGroupingUsed(false);
        object = new ParsePosition(n);
        Number number = decimalFormat.parse(string, (ParsePosition)object);
        if (number == null) {
            return -n;
        }
        n3 = number.intValue();
        int n12 = 1;
        if (n3 < 0) {
            n12 = -1;
            n3 = -n3;
        }
        n3 = n3 < 24 ? (n3 *= 60) : n3 / 100 * 60 + n3 % 100;
        n3 *= 60000;
        if (n12 == -1) {
            n3 = -n3;
        }
        this.calendar.set(15, n3);
        return ((ParsePosition)object).getIndex();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.syms = dateFormatSymbols;
    }

    public String toLocalizedPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.syms.getLocalPatternChars();
        int n = 0;
        while (n < this.pattern.length()) {
            int n2 = DEFAULTPATTERNCHARS.indexOf(this.pattern.charAt(n));
            if (n2 >= 0) {
                stringBuffer.append(string.charAt(n2));
            } else {
                stringBuffer.append(this.pattern.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public SimpleDateFormat() {
        this(SimpleDateFormat.getDefaultPattern(Locale.getDefault()), Locale.getDefault());
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.syms = dateFormatSymbols;
        this.pattern = string;
        this.calendar = new GregorianCalendar();
        this.numberFormat = new DecimalFormat("0");
    }

    public SimpleDateFormat(String string, Locale locale2) {
        this.syms = new DateFormatSymbols(locale2);
        this.pattern = string;
        this.calendar = new GregorianCalendar(locale2);
        this.numberFormat = new DecimalFormat("0", locale2);
    }
}

