/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    private CharacterIterator src;

    public final void reset() {
        this.src.setIndex(0);
    }

    public final int next() {
        char c = this.src.next();
        if (c == '\uffff') {
            return -1;
        }
        return c << 16;
    }

    public final int previous() {
        char c = this.src.previous();
        if (c == '\uffff') {
            return -1;
        }
        return c << 16;
    }

    public static final int primaryOrder(int n) {
        return n >> 16;
    }

    public static final short secondaryOrder(int n) {
        return (short)(n >> 8 & 0xFF);
    }

    public static final short tertiaryOrder(int n) {
        return (short)(n & 0xFF);
    }

    public final void setOffset(int n) {
        this.src.setIndex(n);
    }

    public final int getOffset() {
        return this.src.getIndex();
    }

    public final int getMaxExpansion(int n) {
        return 1;
    }

    public final void setText(String string) {
        this.src = new StringCharacterIterator(string);
    }

    public final void setText(CharacterIterator characterIterator) {
        this.src = characterIterator;
    }

    CollationElementIterator(String string) {
        this.src = new StringCharacterIterator(string);
    }

    CollationElementIterator(CharacterIterator characterIterator) {
        this.src = characterIterator;
    }
}

