/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;

public abstract class Signature
extends SignatureSpi {
    static final String ENGINE_CLASS = "Signature";
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 1;
    protected static final int VERIFY = 2;
    protected int state;
    private final String algorithm;
    private Provider provider;

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        return Signature.getInstance(Security.getCryptInstance(ENGINE_CLASS, string));
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return Signature.getInstance(Security.getCryptInstance(ENGINE_CLASS, string, string2));
    }

    private static final Signature getInstance(Security.Engine engine) {
        Signature signature = (Signature)engine.engine;
        signature.state = 0;
        signature.provider = engine.provider;
        return signature;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engineInitVerify(publicKey);
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    public final void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInitSign(privateKey, secureRandom);
    }

    public final byte[] sign() throws SignatureException {
        return this.engineSign();
    }

    public final int sign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = this.sign();
        if (n2 < byArray2.length) {
            throw new SignatureException();
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    public final boolean verify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray);
    }

    public final void update(byte by) throws SignatureException {
        this.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws SignatureException {
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.engineUpdate(byArray, n, n2);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return super.toString();
    }

    public final void setParameter(String string, Object object) throws InvalidParameterException {
        this.engineSetParameter(string, object);
    }

    public final Object getParameter(String string) throws InvalidParameterException {
        return this.engineGetParameter(string);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected Signature(String string) {
        this.algorithm = string;
    }
}

