/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static final String ENGINE_CLASS = "MessageDigest";
    private final String algorithm;
    private Provider provider;

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(Security.getCryptInstance(ENGINE_CLASS, string));
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigest.getInstance(Security.getCryptInstance(ENGINE_CLASS, string, string2));
    }

    private static final MessageDigest getInstance(Security.Engine engine) {
        MessageDigest messageDigest = (MessageDigest)engine.engine;
        messageDigest.provider = engine.provider;
        return messageDigest;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte by) {
        this.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.engineUpdate(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public byte[] digest() {
        byte[] byArray = this.engineDigest();
        this.engineReset();
        return byArray;
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        int n3 = this.engineGetDigestLength();
        if (n2 < n3) {
            throw new DigestException("buf.length < " + n3);
        }
        System.arraycopy(this.digest(), 0, byArray, n, n3);
        return n3;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        return super.toString();
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        return Arrays.equals(byArray, byArray2);
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected MessageDigest(String string) {
        this.algorithm = string;
    }
}

