/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;
import java.net.UnknownHostException;

public class PlainSocketImpl
extends SocketImpl {
    private InputStream in;
    private OutputStream out;
    private int timeout;
    private boolean closed;

    protected void accept(SocketImpl socketImpl) throws IOException {
        this.socketAccept(socketImpl);
    }

    protected synchronized int available() throws IOException {
        return this.closed ? 0 : this.socketAvailable();
    }

    protected void bind(InetAddress inetAddress, int n) throws IOException {
        this.socketBind(inetAddress, n);
    }

    protected synchronized void close() throws IOException {
        this.closed = true;
        this.in = null;
        this.out = null;
        this.socketClose();
    }

    protected void connect(String string, int n) throws IOException {
        this.connect(InetAddress.getByName(string), n);
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.socketConnect(inetAddress, n);
    }

    protected void create(boolean bl) throws IOException {
        this.socketCreate(bl);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new SocketInputStream(this);
        }
        return this.in;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new SocketOutputStream(this);
        }
        return this.out;
    }

    protected void listen(int n) throws IOException {
        this.socketListen(n);
    }

    protected void setTcpNoDelay(boolean bl) throws SocketException {
        this.socketSetOption(1, new Integer(bl ? 1 : 0));
    }

    protected boolean getTcpNoDelay() throws SocketException {
        return this.socketGetOption(1) != 0;
    }

    protected void setSoLinger(boolean bl, int n) throws SocketException {
        this.socketSetOption(128, new Integer(bl ? n : 0));
    }

    protected int getSoLinger() throws SocketException {
        return this.socketGetOption(128);
    }

    protected void setSoTimeout(int n) throws SocketException {
        this.setOption(4102, new Integer(n));
    }

    protected int getSoTimeout() throws SocketException {
        return (Integer)this.getOption(4102);
    }

    protected void setSendBufferSize(int n) throws SocketException {
        this.socketSetOption(4097, new Integer(n));
    }

    protected int getSendBufferSize() throws SocketException {
        return this.socketGetOption(4097);
    }

    protected void setReceiveBufferSize(int n) throws SocketException {
        this.socketSetOption(4098, new Integer(n));
    }

    protected int getReceiveBufferSize() throws SocketException {
        return this.socketGetOption(4098);
    }

    public void setOption(int n, Object object) throws SocketException {
        boolean bl;
        boolean bl2 = bl = object instanceof Boolean && (Boolean)object == false;
        if (bl) {
            object = new Integer(0);
        }
        switch (n) {
            case 4: 
            case 128: 
            case 4097: 
            case 4098: {
                break;
            }
            case 1: {
                object = new Integer(bl ? 0 : 1);
                break;
            }
            case 4102: {
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n2;
                return;
            }
            case 15: {
                throw new SocketException("Read-only socket option");
            }
            default: {
                throw new SocketException("Unknown socket option");
            }
        }
        this.socketSetOption(n, object);
    }

    public Object getOption(int n) throws SocketException {
        switch (n) {
            case 4: 
            case 128: 
            case 4097: 
            case 4098: {
                return new Integer(this.socketGetOption(n));
            }
            case 1: {
                return new Boolean(this.socketGetOption(n) != 0);
            }
            case 4102: {
                return new Integer(this.timeout);
            }
            case 15: {
                int n2 = this.socketGetOption(n);
                try {
                    return InetAddress.getByName((n2 >> 24 & 0xFF) + "." + (n2 >> 16 & 0xFF) + "." + (n2 >> 8 & 0xFF) + "." + (n2 & 0xFF));
                }
                catch (UnknownHostException unknownHostException) {
                    throw new Error("impossible result");
                }
            }
        }
        throw new SocketException("Unknown socket option");
    }

    protected int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n3 = this.socketRead(byArray, n, n2);
        if (n3 > 0 || n2 == 0) {
            return n3;
        }
        return -1;
    }

    protected void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("socket closed");
        }
        this.socketWrite(byArray, n, n2);
    }

    public native void socketSetOption(int var1, Object var2) throws SocketException;

    public native int socketGetOption(int var1) throws SocketException;

    private final native void socketAccept(SocketImpl var1);

    private final native int socketAvailable();

    private final native void socketBind(InetAddress var1, int var2);

    private final native void socketClose();

    private final native void socketConnect(InetAddress var1, int var2);

    private final native void socketCreate(boolean var1);

    private final native void socketListen(int var1);

    private final native int socketRead(byte[] var1, int var2, int var3) throws IOException;

    private final native void socketWrite(byte[] var1, int var2, int var3) throws IOException;

    static {
        System.loadLibrary("net");
    }
}

