/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Method
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Method)) {
            return false;
        }
        Method method = (Method)object;
        if (this.clazz != method.clazz || this.returnType != method.returnType || this.parameterTypes.length != method.parameterTypes.length || !this.name.equals(method.name)) {
            return false;
        }
        int n = this.parameterTypes.length;
        while (n-- > 0) {
            if (this.parameterTypes[n] == method.parameterTypes[n]) continue;
            return false;
        }
        return true;
    }

    public final Class getDeclaringClass() {
        return this.clazz;
    }

    public final Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public final native int getModifiers();

    public final String getName() {
        return this.name;
    }

    public final Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public final Class getReturnType() {
        return this.returnType;
    }

    public final int hashCode() {
        return this.clazz.getName().hashCode() ^ this.name.hashCode();
    }

    public final native Object invoke(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (n != 0) {
            stringBuffer.append(Modifier.toString(n));
            stringBuffer.append(' ');
        }
        stringBuffer.append(Method.getPrettyName(this.returnType));
        stringBuffer.append(' ');
        stringBuffer.append(this.clazz.getName());
        stringBuffer.append('.');
        stringBuffer.append(this.name);
        stringBuffer.append('(');
        int n2 = 0;
        while (n2 < this.parameterTypes.length) {
            stringBuffer.append(Method.getPrettyName(this.parameterTypes[n2]));
            if (n2 + 1 < this.parameterTypes.length) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        stringBuffer.append(')');
        if (this.exceptionTypes.length > 0) {
            stringBuffer.append(" throws ");
            n2 = 0;
            while (n2 < this.exceptionTypes.length) {
                stringBuffer.append(this.exceptionTypes[n2].getName());
                if (n2 + 1 < this.exceptionTypes.length) {
                    stringBuffer.append(',');
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    static final String getPrettyName(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            if (!clazz.isArray()) {
                stringBuffer.append(clazz.getName());
                while (n > 0) {
                    stringBuffer.append("[]");
                    --n;
                }
                return stringBuffer.toString();
            }
            clazz = clazz.getComponentType();
            ++n;
        }
    }

    private Method() {
    }
}

