/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public final class Array {
    public static final native Object get(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native boolean getBoolean(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native byte getByte(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native char getChar(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native double getDouble(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native float getFloat(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native int getInt(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native int getLength(Object var0) throws IllegalArgumentException;

    public static final native long getLong(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native short getShort(Object var0, int var1) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    private static final native Object multiNewArray(Class var0, int[] var1);

    private static final native Object newArray(Class var0, int var1);

    public static final Object newInstance(Class clazz, int n) throws NegativeArraySizeException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        return Array.newArray(clazz, n);
    }

    public static final Object newInstance(Class clazz, int[] nArray) throws IllegalArgumentException, NegativeArraySizeException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (nArray.length == 0 || nArray.length > 255) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0) {
                throw new NegativeArraySizeException();
            }
            ++n;
        }
        return Array.multiNewArray(clazz, nArray);
    }

    public static final native void set(Object var0, int var1, Object var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native void setBoolean(Object var0, int var1, boolean var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native void setByte(Object var0, int var1, byte var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native void setChar(Object var0, int var1, char var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native void setDouble(Object var0, int var1, double var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native void setFloat(Object var0, int var1, float var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native void setInt(Object var0, int var1, int var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native void setLong(Object var0, int var1, long var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static final native void setShort(Object var0, int var1, short var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

    private Array() {
    }
}

