/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import java.util.Vector;

public class ReferenceQueue {
    private Vector que = new Vector();

    public Reference poll() {
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (!this.que.isEmpty()) {
                Reference reference = (Reference)this.que.firstElement();
                this.que.removeElement(reference);
                return reference;
            }
            return null;
        }
    }

    public Reference remove(long l) throws IllegalArgumentException, InterruptedException {
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            do {
                if (!this.que.isEmpty()) {
                    Reference reference = (Reference)this.que.firstElement();
                    this.que.removeElement(reference);
                    return reference;
                }
                this.wait(l);
            } while (l <= 0L);
            return null;
        }
    }

    public Reference remove() throws InterruptedException {
        return this.remove(0L);
    }

    boolean isEnqueued(Reference reference) {
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            return this.que.contains(reference);
            {
            }
        }
    }

    void enqueue(Reference reference) {
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            this.que.addElement(reference);
            this.notify();
        }
    }
}

