/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public class ThreadGroup {
    private ThreadGroup parent;
    private String name;
    private int maxPriority;
    private boolean destroyed = false;
    private boolean daemon = false;
    private int nthreads = 0;
    private Thread[] threads = new Thread[0];
    private int ngroups = 0;
    private ThreadGroup[] groups = new ThreadGroup[0];

    public synchronized int activeCount() {
        int n = this.nthreads;
        int n2 = 0;
        while (n2 < this.groups.length) {
            if (this.groups[n2] != null) {
                n += this.groups[n2].activeCount();
            }
            ++n2;
        }
        return n;
    }

    public synchronized int activeGroupCount() {
        int n = this.ngroups;
        int n2 = 0;
        while (n2 < this.groups.length) {
            if (this.groups[n2] != null) {
                n += this.groups[n2].activeGroupCount();
            }
            ++n2;
        }
        return n;
    }

    synchronized void add(Thread thread) {
        ++this.nthreads;
        if (this.threads == null) {
            this.threads = new Thread[1];
        }
        int n = 0;
        while (n < this.threads.length) {
            if (this.threads[n] == null) {
                this.threads[n] = thread;
                return;
            }
            ++n;
        }
        Thread[] threadArray = new Thread[this.threads.length + 1];
        System.arraycopy(this.threads, 0, threadArray, 0, this.threads.length);
        this.threads = threadArray;
        this.threads[this.threads.length - 1] = thread;
    }

    synchronized void add(ThreadGroup threadGroup) {
        ++this.ngroups;
        int n = 0;
        while (n < this.groups.length) {
            if (this.groups[n] == null) {
                this.groups[n] = threadGroup;
                return;
            }
            ++n;
        }
        ThreadGroup[] threadGroupArray = new ThreadGroup[this.groups.length + 1];
        System.arraycopy(this.groups, 0, threadGroupArray, 0, this.groups.length);
        this.groups = threadGroupArray;
        this.groups[this.groups.length - 1] = threadGroup;
    }

    public boolean allowThreadSuspension(boolean bl) {
        return false;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public final synchronized void destroy() {
        this.checkAccess();
        if (this.destroyed || this.activeCount() > 0) {
            throw new IllegalThreadStateException();
        }
        int n = 0;
        while (n < this.groups.length) {
            if (this.groups[n] != null) {
                this.groups[n].destroy();
                this.groups[n] = null;
            }
            ++n;
        }
        this.ngroups = 0;
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.destroyed = true;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, true, 0);
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl) {
        this.checkAccess();
        return this.enumerate(threadGroupArray, bl, 0);
    }

    private final int enumerate(ThreadGroup[] threadGroupArray, boolean bl, int n) {
        int n2;
        ThreadGroup[] threadGroupArray2 = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            n2 = 0;
            while (n2 < this.groups.length && n < threadGroupArray.length) {
                if (this.groups[n2] != null) {
                    threadGroupArray[n++] = this.groups[n2];
                }
                ++n2;
            }
            if (bl && this.groups != null) {
                threadGroupArray2 = new ThreadGroup[this.groups.length];
                System.arraycopy(this.groups, 0, threadGroupArray2, 0, this.groups.length);
            }
        }
        if (threadGroupArray2 != null) {
            n2 = 0;
            while (n2 < threadGroupArray2.length) {
                if (threadGroupArray2[n2] != null) {
                    n = threadGroupArray2[n2].enumerate(threadGroupArray, true, n);
                }
                ++n2;
            }
        }
        return n;
    }

    public int enumerate(Thread[] threadArray) {
        this.checkAccess();
        return this.enumerate(threadArray, true, 0);
    }

    public int enumerate(Thread[] threadArray, boolean bl) {
        this.checkAccess();
        return this.enumerate(threadArray, bl, 0);
    }

    private final int enumerate(Thread[] threadArray, boolean bl, int n) {
        int n2;
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            n2 = 0;
            while (n2 < this.threads.length && n < threadArray.length) {
                if (this.threads[n2] != null && this.threads[n2].isAlive()) {
                    threadArray[n++] = this.threads[n2];
                }
                ++n2;
            }
            if (bl && this.groups != null) {
                threadGroupArray = new ThreadGroup[this.groups.length];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, this.groups.length);
            }
        }
        if (threadGroupArray != null) {
            n2 = 0;
            while (n2 < threadGroupArray.length) {
                if (threadGroupArray[n2] != null) {
                    n = threadGroupArray[n2].enumerate(threadArray, true, n);
                }
                ++n2;
            }
        }
        return n;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        return this.parent;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized void list() {
        this.list(0);
    }

    private final void list(int n) {
        this.printLine(this.toString(), n);
        this.printThreads(n + 1);
        this.printGroups(n + 1);
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        return this.parent == threadGroup || this.parentOf(threadGroup.getParent());
    }

    private final void printGroups(int n) {
        int n2 = 0;
        while (n2 < this.groups.length) {
            if (this.groups[n2] != null) {
                this.groups[n2].list(n);
            }
            ++n2;
        }
    }

    private final void printLine(String string, int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("    ");
            ++n2;
        }
        System.out.println(string);
    }

    private final void printThreads(int n) {
        int n2 = 0;
        while (n2 < this.threads.length) {
            if (this.threads[n2] != null) {
                this.printLine(this.threads[n2].toString(), n);
            }
            ++n2;
        }
    }

    synchronized void remove(Thread thread) {
        int n = 0;
        while (n < this.threads.length) {
            if (this.threads[n] == thread) {
                this.threads[n] = null;
                --this.nthreads;
                break;
            }
            ++n;
        }
    }

    synchronized void remove(ThreadGroup threadGroup) {
        int n = 0;
        while (n < this.groups.length) {
            if (this.groups[n] == threadGroup) {
                this.groups[n] = null;
                --this.ngroups;
                break;
            }
            ++n;
        }
    }

    public final synchronized void resume() {
        this.checkAccess();
        int n = 0;
        while (n < this.threads.length) {
            if (this.threads[n] != null) {
                this.threads[n].resume();
            }
            ++n;
        }
        n = 0;
        while (n < this.groups.length) {
            if (this.groups[n] != null) {
                this.groups[n].resume();
            }
            ++n;
        }
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        this.daemon = bl;
    }

    public final synchronized void setMaxPriority(int n) {
        this.checkAccess();
        this.maxPriority = n;
    }

    public final synchronized void stop() {
        this.checkAccess();
        int n = 0;
        while (n < this.threads.length) {
            if (this.threads[n] != null) {
                this.threads[n].stop();
            }
            ++n;
        }
        n = 0;
        while (n < this.groups.length) {
            if (this.groups[n] != null) {
                this.groups[n].stop();
            }
            ++n;
        }
    }

    public final synchronized void suspend() {
        this.checkAccess();
        int n = 0;
        while (n < this.threads.length) {
            if (this.threads[n] != null) {
                this.threads[n].suspend();
            }
            ++n;
        }
        n = 0;
        while (n < this.groups.length) {
            if (this.groups[n] != null) {
                this.groups[n].suspend();
            }
            ++n;
        }
    }

    public String toString() {
        return "java.lang.ThreadGroup[name=" + this.name + ",maxpri=" + this.maxPriority + "]";
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
        } else if (!(throwable instanceof ThreadDeath)) {
            throwable.printStackTrace(System.err);
        }
    }

    private ThreadGroup() {
        this(Thread.currentThread().getThreadGroup(), "main");
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        threadGroup.checkAccess();
        this.name = string;
        this.parent = threadGroup;
        this.maxPriority = threadGroup.getMaxPriority();
        this.daemon = threadGroup.isDaemon();
        threadGroup.add(this);
    }
}

