/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuffer
implements Serializable {
    private static final int SPARECAPACITY = 16;
    private static final long serialVersionUID = 3388685877147921107L;
    char[] buffer;
    int used;
    boolean isStringized;

    public final StringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public final StringBuffer append(String string) {
        if (string == null) {
            string = "null";
        }
        return this.append(string.value, string.offset, string.count);
    }

    public final StringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public final synchronized StringBuffer append(char c) {
        if (this.used + 1 > this.buffer.length || this.isStringized) {
            this.ensureCapacity(this.used + 1, this.isStringized);
        }
        this.buffer[this.used++] = c;
        return this;
    }

    public final StringBuffer append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public final synchronized StringBuffer append(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.used + n2 > this.buffer.length || this.isStringized) {
            this.ensureCapacity(this.used + n2, this.isStringized);
        }
        System.arraycopy(cArray, n, this.buffer, this.used, n2);
        this.used += n2;
        return this;
    }

    public final StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public final StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public final StringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public final StringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public final int capacity() {
        return this.buffer.length;
    }

    public final synchronized char charAt(int n) {
        if (n >= this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.buffer[n];
    }

    public final synchronized StringBuffer deleteCharAt(int n) {
        if (n < 0 || n >= this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, n + 1, this.buffer, n, --this.used - n);
        return this;
    }

    public final synchronized StringBuffer delete(int n, int n2) {
        if (n2 > this.used) {
            n2 = this.used;
        }
        if (n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, n2, this.buffer, n, this.used - n2);
        this.used -= n2 - n;
        return this;
    }

    public final synchronized StringBuffer replace(int n, int n2, String string) {
        return this.delete(n, n2).insert(n, string);
    }

    public final synchronized String substring(int n) {
        return this.substring(n, this.used);
    }

    public final synchronized String substring(int n, int n2) {
        int n3 = n2 - n;
        if (n < 0 || n2 > this.used || n3 < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.buffer.length - n3 > 32) {
            return new String(this.buffer, n, n2);
        }
        this.isStringized = true;
        return new String(n, n2, this.buffer);
    }

    public final void ensureCapacity(int n) {
        if (n <= 0) {
            return;
        }
        StringBuffer stringBuffer = this;
        synchronized (stringBuffer) {
            this.ensureCapacity(n, this.isStringized);
        }
    }

    private final boolean ensureCapacity(int n, boolean bl) {
        if (!bl && n <= this.buffer.length) {
            return false;
        }
        if (n < this.used) {
            n = this.used;
        } else if (n < this.buffer.length * 2 + 2) {
            n = this.buffer.length * 2 + 2;
        }
        char[] cArray = new char[n];
        System.arraycopy(this.buffer, 0, cArray, 0, this.used);
        this.buffer = cArray;
        this.isStringized = false;
        return true;
    }

    public final synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n2 > this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, n, cArray, n3, n2 - n);
    }

    public final synchronized StringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public final synchronized StringBuffer insert(int n, String string) {
        if (string == null) {
            string = "null";
        }
        return this.insert(n, string.value, string.offset, string.count);
    }

    public final StringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public final synchronized StringBuffer insert(int n, char c) {
        return this.insert(n, new char[]{c}, 0, 1);
    }

    public final StringBuffer insert(int n, char[] cArray) {
        return this.insert(n, cArray, 0, cArray.length);
    }

    public final synchronized StringBuffer insert(int n, char[] cArray, int n2, int n3) {
        if (n < 0 || n > this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.used + n3 > this.buffer.length || this.isStringized) {
            this.ensureCapacity(this.used + n3, this.isStringized);
        }
        System.arraycopy(this.buffer, n, this.buffer, n + n3, this.used - n);
        System.arraycopy(cArray, n2, this.buffer, n, n3);
        this.used += n3;
        return this;
    }

    public final StringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public final StringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public final StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public final StringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public final int length() {
        return this.used;
    }

    public final synchronized StringBuffer reverse() {
        if (this.isStringized) {
            this.ensureCapacity(this.used, true);
        }
        int n = this.used / 2 - 1;
        while (n >= 0) {
            char c = this.buffer[n];
            this.buffer[n] = this.buffer[this.used - n - 1];
            this.buffer[this.used - n - 1] = c;
            --n;
        }
        return this;
    }

    public final synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.used) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.isStringized) {
            this.ensureCapacity(this.used, true);
        }
        this.buffer[n] = c;
    }

    public final synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        boolean bl = this.ensureCapacity(n, this.isStringized);
        if (!bl && n > this.used) {
            int n2 = this.used;
            while (n2 < n) {
                this.buffer[n2] = '\u0000';
                ++n2;
            }
        }
        this.used = n;
    }

    public final String toString() {
        return new String(this);
    }

    public StringBuffer() {
        this.buffer = new char[16];
    }

    public StringBuffer(String string) {
        this.used = string.count;
        this.buffer = new char[this.used + 16];
        System.arraycopy(string.value, string.offset, this.buffer, 0, this.used);
    }

    public StringBuffer(int n) {
        this.buffer = new char[n];
    }
}

