/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.util.StringTokenizer;

class NativeLibrary {
    private int libIndex = -1;

    public static String[] getLibraryNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.library.path"), new String(new char[]{File.pathSeparatorChar}));
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken() + File.separator + System.mapLibraryName(string);
            ++n;
        }
        return stringArray;
    }

    protected void finalize() throws Throwable {
        if (this.libIndex != -1) {
            NativeLibrary.unlinkLibrary(this.libIndex);
        }
        super.finalize();
    }

    private static final synchronized native int linkLibrary(String var0);

    private static final synchronized native void unlinkLibrary(int var0);

    public static native String getLibPrefix();

    public static native String getLibSuffix();

    public NativeLibrary(String string, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        this.libIndex = NativeLibrary.linkLibrary(string);
        classLoader.addNativeLibrary(this);
    }
}

