/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;

    public static final native double IEEEremainder(double var0, double var2);

    public static final double abs(double d) {
        return d < 0.0 ? -d : d;
    }

    public static final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static final native double acos(double var0);

    public static final native double asin(double var0);

    public static final native double atan(double var0);

    public static final native double atan2(double var0, double var2);

    public static final native double ceil(double var0);

    public static final native double cos(double var0);

    public static final native double exp(double var0);

    public static final native double floor(double var0);

    public static final native double log(double var0);

    public static final double max(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return d2 > d ? d2 : d;
    }

    public static final float max(float f, float f2) {
        if (Float.isNaN(f) || Float.isNaN(f2)) {
            return Float.NaN;
        }
        return f2 > f ? f2 : f;
    }

    public static final int max(int n, int n2) {
        return n2 > n ? n2 : n;
    }

    public static final long max(long l, long l2) {
        return l2 > l ? l2 : l;
    }

    public static final double min(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        return d < d2 ? d : d2;
    }

    public static final float min(float f, float f2) {
        if (Float.isNaN(f) || Float.isNaN(f2)) {
            return Float.NaN;
        }
        return f < f2 ? f : f2;
    }

    public static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    public static final native double pow(double var0, double var2);

    public static final synchronized double random() {
        return MathRandom.random.nextDouble();
    }

    public static final native double rint(double var0);

    public static final long round(double d) {
        if (d < -9.223372036854776E18 || d == Double.NEGATIVE_INFINITY) {
            return Long.MIN_VALUE;
        }
        if (d > 9.223372036854776E18 || d == Double.POSITIVE_INFINITY) {
            return Long.MAX_VALUE;
        }
        return (long)Math.floor(d + 0.5);
    }

    public static final int round(float f) {
        if (f < -2.1474836E9f || f == Float.NEGATIVE_INFINITY) {
            return Integer.MIN_VALUE;
        }
        if (f > 2.1474836E9f || f == Float.POSITIVE_INFINITY) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.floor((double)f + 0.5);
    }

    public static final native double sin(double var0);

    public static final native double sqrt(double var0);

    public static final native double tan(double var0);

    public static final double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static final double toRadians(double d) {
        return d * Math.PI / 180.0;
    }

    private Math() {
    }
}

