/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Vector;
import kaffe.lang.SystemClassLoader;

public final class Class
implements Serializable {
    public static final Class forName(String string) throws ClassNotFoundException {
        Class clazz = Class.getStackClass(1);
        if (clazz != null && clazz.getName().equals("java.lang.reflect.Method")) {
            clazz = Class.getStackClass(2);
        }
        return Class.forName(string, true, clazz == null ? null : clazz.getClassLoader());
    }

    public static final native Class forName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    private final String fullResourceName(String string) {
        if (string.charAt(0) == '/') {
            return string.substring(1);
        }
        String string2 = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            stringBuffer.append(string2.substring(0, n + 1).replace('.', '/'));
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public final ClassLoader getClassLoader() {
        return this.getClassLoader0();
    }

    private final native ClassLoader getClassLoader0();

    public final Class getDeclaringClass() {
        Class[] classArray = this.getClasses0(false);
        switch (classArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return classArray[0];
            }
        }
        throw new ClassFormatError("Too many outer classes :" + classArray.length);
    }

    public final Class[] getClasses() {
        SecurityManager securityManager = System.getSecurityManager();
        Vector vector = new Vector();
        Class clazz = this;
        while (clazz != null) {
            if (securityManager != null) {
                securityManager.checkMemberAccess(clazz, 0);
            }
            Class[] classArray = clazz.getClasses0(true);
            int n = 0;
            while (n < classArray.length) {
                if (Modifier.isPublic(classArray[n].getModifiers())) {
                    vector.add(classArray[n]);
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        return (Class[])vector.toArray(new Class[vector.size()]);
    }

    private final native Class[] getClasses0(boolean var1);

    public final native Class getComponentType();

    public final Constructor getConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getConstructor0(classArray, false);
    }

    private final native Constructor getConstructor0(Class[] var1, boolean var2);

    public final Constructor[] getConstructors() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getConstructors0(false);
    }

    private final native Constructor[] getConstructors0(boolean var1);

    public final Class[] getDeclaredClasses() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getClasses0(true);
    }

    public final Constructor getDeclaredConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getConstructor0(classArray, true);
    }

    public final Constructor[] getDeclaredConstructors() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getConstructors0(true);
    }

    public final Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getField0(string, true);
    }

    public final Field[] getDeclaredFields() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getFields0(true);
    }

    public final Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getMethod0(string, classArray, true);
    }

    public final Method[] getDeclaredMethods() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getMethods0(true);
    }

    public final Field getField(String string) throws NoSuchFieldException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getField0(string, false);
    }

    private final native Field getField0(String var1, boolean var2);

    public final Field[] getFields() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getFields0(false);
    }

    private final native Field[] getFields0(boolean var1);

    public final native Class[] getInterfaces();

    public final Method getMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getMethod0(string, classArray, false);
    }

    private final native Method getMethod0(String var1, Class[] var2, boolean var3);

    public final Method[] getMethods() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getMethods0(false);
    }

    private final native Method[] getMethods0(boolean var1);

    public final native int getModifiers();

    public final native String getName();

    static final native Class getPrimitiveClass(String var0);

    public final URL getResource(String string) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = SystemClassLoader.getClassLoader();
        }
        return classLoader.getResource(this.fullResourceName(string));
    }

    public final InputStream getResourceAsStream(String string) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            classLoader = SystemClassLoader.getClassLoader();
        }
        InputStream inputStream = classLoader.getResourceAsStream(this.fullResourceName(string));
        return inputStream;
    }

    public final native Object[] getSigners();

    final native void setSigners(Object[] var1);

    public final native Class getSuperclass();

    public final native boolean isArray();

    public final native boolean isAssignableFrom(Class var1);

    public final native boolean isInstance(Object var1);

    public final native boolean isInterface();

    public final native boolean isPrimitive();

    public final native Object newInstance() throws InstantiationException, IllegalAccessException;

    public final String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    static final Class getStackClass(int n) {
        Class[] classArray = SecurityManager.getClassContext0();
        if ((n += 2) >= 0 && n < classArray.length) {
            return classArray[n];
        }
        return null;
    }

    private Class() {
    }
}

