/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    protected Object lock;
    private final char[] single = new char[1];

    public abstract void close() throws IOException;

    public void mark(int n) throws IOException {
        throw new IOException("mark() not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.read(this.single, 0, 1) < 0 ? -1 : this.single[0];
        }
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public boolean ready() throws IOException {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    public long skip(long l) throws IOException {
        char[] cArray = new char[1024];
        int n = 0;
        while (l > 0L) {
            int n2 = this.read(cArray, 0, (long)cArray.length < l ? cArray.length : (int)l);
            if (n2 < 0) break;
            l -= (long)n2;
            n += n2;
        }
        return n;
    }

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock = object;
    }
}

