/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private static final int DEFAULT_PUSHBACK_BUFFER_SIZE = 1;
    private PushbackBuffer pbuf;

    private final void checkIfStillOpen() throws IOException {
        if (this.pbuf == null) {
            throw new IOException("Stream closed");
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.pbuf = null;
        }
        super.close();
    }

    public void mark(int n) throws IOException {
        PushbackReader.throwMarkException();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (this.pbuf.isEmpty()) {
                return super.read();
            }
            return this.pbuf.read();
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        if (!PushbackReader.validArguments(cArray, n, n2)) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            n3 += this.pbuf.read(cArray, n, n2);
            n += n3;
            if ((n2 -= n3) > 0) {
                n4 = super.read(cArray, n, n2);
            }
        }
        if (n4 == -1) {
            if (n3 == 0) {
                n3 = -1;
            }
        } else {
            n3 += n4;
        }
        return n3;
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            return !this.pbuf.isEmpty() || super.ready();
        }
    }

    public void reset() throws IOException {
        PushbackReader.throwMarkException();
    }

    private static final void throwMarkException() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public void unread(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.pbuf.unread((char)n);
        }
    }

    public void unread(char[] cArray, int n, int n2) throws IOException {
        if (!PushbackReader.validArguments(cArray, n, n2)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.pbuf.unread(cArray, n, n2);
        }
    }

    public void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    private static final boolean validArguments(char[] cArray, int n, int n2) {
        return n >= 0 && n < cArray.length && n2 >= 0 && n2 <= cArray.length - n;
    }

    public PushbackReader(Reader reader, int n) {
        super(reader);
        if (n <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.pbuf = new PushbackBuffer(this, null, n);
    }

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }

    private class PushbackBuffer {
        private char[] buf;
        private int pos;
        private final /* synthetic */ PushbackReader this$0;

        private final int capacity() {
            return this.pos;
        }

        private final boolean isEmpty() {
            return this.capacity() == this.buf.length;
        }

        private final boolean isFull() {
            return this.capacity() == 0;
        }

        private final int length() {
            return this.buf.length - this.capacity();
        }

        private final char read() {
            return this.buf[this.pos++];
        }

        private final int read(char[] cArray, int n, int n2) {
            n2 = Math.min(n2, this.length());
            System.arraycopy(this.buf, this.pos, cArray, n, n2);
            this.pos += n2;
            return n2;
        }

        private final void throwOverflowException() throws IOException {
            throw new IOException("Pushback buffer overflow");
        }

        private final void unread(char c) throws IOException {
            if (this.isFull()) {
                this.throwOverflowException();
            }
            this.buf[--this.pos] = c;
        }

        private final void unread(char[] cArray, int n, int n2) throws IOException {
            if (n2 > this.capacity()) {
                this.throwOverflowException();
            }
            this.pos -= n2;
            System.arraycopy(cArray, n, this.buf, this.pos, n2);
        }

        private PushbackBuffer(PushbackReader pushbackReader, int n) {
            this.this$0 = pushbackReader;
            this.buf = new char[n];
            this.pos = this.buf.length;
        }

        /*
         * Exception decompiling
         */
        /* synthetic */ PushbackBuffer(PushbackReader var1, 1 var2, int var3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: While processing lbl3 : INVOKESPECIAL - null : Stack underflow
             *     at org.benf.cfr.reader.bytecode.analysis.stack.StackSim.getChange(StackSim.java:81)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.populateStackInfo(Op02WithProcessedDataAndRefs.java:242)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.populateStackInfo(Op02WithProcessedDataAndRefs.java:1559)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:434)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

