/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos;
    protected int count;

    private final void checkIfStillOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (this.pos < this.count) {
                return this.buf[this.pos++];
            }
        }
        return -1;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos < this.count) {
                int n3 = Math.min(n2, this.count - this.pos);
                System.arraycopy(this.buf, this.pos, cArray, n, n3);
                this.pos += n3;
                return n3;
            }
        }
        return -1;
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            int n = (int)Math.min(l, (long)(this.count - this.pos));
            if (n < 0) {
                n = 0;
            }
            this.pos += n;
            return n;
        }
    }

    public boolean ready() throws IOException {
        this.checkIfStillOpen();
        return this.pos < this.count;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.markedPos = this.pos;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.pos = this.markedPos;
        }
    }

    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
        }
    }

    public CharArrayReader(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public CharArrayReader(char[] cArray, int n, int n2) {
        if (n < 0 || n > cArray.length || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = cArray;
        this.pos = n;
        this.count = n + n2 < cArray.length ? n + n2 : cArray.length;
        this.markedPos = n;
    }
}

