/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import kaffe.io.ByteToCharConverter;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    private final void ensureCapacity(int n) {
        if (n > this.buf.length) {
            byte[] byArray = this.buf;
            this.buf = new byte[n + 32];
            System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
        }
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public String toString() {
        return this.toString(ByteToCharConverter.getDefault());
    }

    private final String toString(ByteToCharConverter byteToCharConverter) {
        int n = byteToCharConverter.getNumberOfChars(this.buf, 0, this.count);
        char[] cArray = new char[n];
        byteToCharConverter.convert(this.buf, 0, this.count, cArray, 0, cArray.length);
        return new String(cArray);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return this.toString(ByteToCharConverter.getConverter(string));
    }

    public String toString(int n) {
        return new String(this.buf, n, 0, this.count);
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        this.ensureCapacity(this.count + n2);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public synchronized void write(int n) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count++] = (byte)n;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int n) {
        this.buf = new byte[n];
        this.count = 0;
    }
}

