/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private static final int DEFAULTBUFFERSIZE = 8192;
    private Reader rd;
    private char[] inbuf;
    private int pos;
    private int size;
    private boolean markset;
    private boolean markvalid;

    private final void checkIfStillOpen() throws IOException {
        if (this.rd == null) {
            throw new IOException("Stream closed");
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.rd == null) {
                return;
            }
            this.rd.close();
            this.inbuf = null;
            this.rd = null;
            this.lock = this;
        }
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            char[] cArray = this.inbuf;
            if (n > this.inbuf.length) {
                this.inbuf = new char[n];
            }
            System.arraycopy(cArray, this.pos, this.inbuf, 0, this.size - this.pos);
            this.size -= this.pos;
            this.pos = 0;
            this.markset = true;
            this.markvalid = true;
        }
    }

    public boolean markSupported() {
        return true;
    }

    void pushback() {
        Object object = this.lock;
        synchronized (object) {
            --this.pos;
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (this.pos < this.size || this.fillOutBuffer() > 0) {
                return this.inbuf[this.pos++];
            }
        }
        return -1;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n + n2 > cArray.length || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (this.pos == this.size && !this.markset && n2 >= this.inbuf.length) {
                return this.rd.read(cArray, n, n2);
            }
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                if (this.pos == this.size) {
                    if (n3 > 0 && !this.rd.ready()) {
                        return n3;
                    }
                    if (this.fillOutBuffer() <= 0) {
                        return n3 > 0 ? n3 : -1;
                    }
                }
                if ((n4 = n2 - n3) > this.size - this.pos) {
                    n4 = this.size - this.pos;
                }
                System.arraycopy(this.inbuf, this.pos, cArray, n, n4);
                this.pos += n4;
                n += n4;
                n3 += n4;
            }
            return n3;
        }
    }

    public String readLine() throws IOException {
        int n = 32;
        String string = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            int n2 = this.pos;
            while (true) {
                if (this.pos < this.size && (n = this.inbuf[this.pos]) != 10 && n != 13) {
                    ++this.pos;
                    continue;
                }
                if (this.pos != this.size) break;
                if (this.pos > n2) {
                    string = string == null ? new String(this.inbuf, n2, this.pos - n2) : string + new String(this.inbuf, n2, this.pos - n2);
                }
                if (this.fillOutBuffer() < 0) {
                    return string;
                }
                n2 = 0;
            }
            string = string == null ? new String(this.inbuf, n2, this.pos - n2) : string + new String(this.inbuf, n2, this.pos - n2);
            ++this.pos;
            if (n == 13) {
                int n3;
                char[] cArray = new char[1];
                while ((n3 = this.read(cArray, 0, 1)) == 0) {
                }
                if (n3 == 1 && cArray[0] != '\n' && this.pos > 0) {
                    --this.pos;
                }
            }
            return string;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            return this.pos < this.size || this.rd.ready();
        }
    }

    private final int fillOutBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n = this.pos;
            if (this.markset) {
                if (n == this.inbuf.length) {
                    n = 0;
                }
            } else {
                n = 0;
            }
            int n2 = this.rd.read(this.inbuf, n, this.inbuf.length - n);
            if (this.markset && this.pos == this.inbuf.length) {
                this.markvalid = false;
            }
            this.pos = n;
            if (n2 >= 0) {
                this.size = n + n2;
                return n2;
            }
            this.size = n;
            return -1;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (!this.markset) {
                throw new IOException("Stream not marked");
            }
            if (!this.markvalid) {
                throw new IOException("Mark invalid");
            }
            this.pos = 0;
        }
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            long l2 = this.size - this.pos;
            if (l2 > l) {
                l2 = l;
            }
            this.pos += (int)l2;
            if (l2 == l) {
                return l;
            }
            this.pos = 0;
            this.size = 0;
            this.markvalid = false;
            return l2 + this.rd.skip(l - l2);
        }
    }

    public BufferedReader(Reader reader) {
        this(reader, 8192);
    }

    public BufferedReader(Reader reader, int n) {
        super(reader);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.rd = reader;
        this.inbuf = new char[n];
    }
}

