/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class FilteredImageSource
implements ImageProducer {
    ImageProducer producer;
    ImageFilter filter;
    Hashtable table = new Hashtable();

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (this.table.containsKey(imageConsumer)) {
            return;
        }
        ImageFilter imageFilter = this.filter.getFilterInstance(imageConsumer);
        this.table.put(imageConsumer, imageFilter);
        this.producer.addConsumer(imageFilter);
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        ImageFilter imageFilter = (ImageFilter)this.table.get(imageConsumer);
        if (imageFilter != null) {
            return this.producer.isConsumer(imageFilter);
        }
        return false;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        ImageFilter imageFilter = (ImageFilter)this.table.get(imageConsumer);
        if (imageFilter != null) {
            this.producer.removeConsumer(imageFilter);
            this.table.remove(imageConsumer);
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        ImageFilter imageFilter = (ImageFilter)this.table.get(imageConsumer);
        if (imageFilter != null) {
            this.producer.requestTopDownLeftRightResend(imageFilter);
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        ImageFilter imageFilter = (ImageFilter)this.table.get(imageConsumer);
        if (imageFilter == null) {
            imageFilter = this.filter.getFilterInstance(imageConsumer);
            this.table.put(imageConsumer, imageFilter);
        }
        this.producer.startProduction(imageFilter);
    }

    public FilteredImageSource(ImageProducer imageProducer, ImageFilter imageFilter) {
        this.producer = imageProducer;
        this.filter = imageFilter;
    }
}

