/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class GridLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -7411804673224730901L;
    int cols;
    int rows;
    int hgap;
    int vgap;

    public void addLayoutComponent(String string, Component component) {
    }

    Dimension adjustDim(Container container) {
        Dimension dimension = new Dimension(this.cols, this.rows);
        int n = container.getComponentCount();
        if (this.rows > 0) {
            dimension.height = this.rows;
            dimension.width = n / this.rows;
            if (n % this.rows != 0) {
                ++dimension.width;
            }
        } else {
            dimension.width = this.cols;
            dimension.height = n / this.cols;
            if (n % this.cols != 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }

    public int getColumns() {
        return this.cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    Dimension getLayoutSize(Container container, boolean bl) {
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.adjustDim(container);
        int n3 = container.getComponentCount();
        int n4 = 0;
        while (n4 < n3) {
            Component component = container.getComponent(n4);
            Dimension dimension2 = bl ? component.getPreferredSize() : component.getMinimumSize();
            n = Math.max(n, dimension2.width);
            n2 = Math.max(n2, dimension2.height);
            ++n4;
        }
        Insets insets = container.getInsets();
        return new Dimension(insets.left + insets.right + n * dimension.width + this.hgap * (dimension.width + 1), insets.top + insets.bottom + n2 * dimension.height + this.vgap * (dimension.height + 1));
    }

    public int getRows() {
        return this.rows;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void layoutContainer(Container container) {
        int n;
        int n2 = container.getComponentCount();
        if (n2 == 0) {
            return;
        }
        Insets insets = container.getInsets();
        int n3 = container.width - insets.left - insets.right - this.hgap;
        int n4 = container.height - insets.top - insets.bottom - this.vgap;
        Dimension dimension = this.adjustDim(container);
        int n5 = n3 / dimension.width;
        int n6 = n4 / dimension.height;
        int n7 = n = insets.left + this.hgap;
        int n8 = insets.top + this.vgap;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            Component component = container.getComponent(n10);
            component.setBounds(n7, n8, n5 - this.hgap, n6 - this.vgap);
            if (n9 == dimension.width - 1) {
                n9 = 0;
                n7 = n;
                n8 += n6;
            } else {
                ++n9;
                n7 += n5;
            }
            ++n10;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setColumns(int n) {
        this.cols = n;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setRows(int n) {
        this.rows = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public String toString() {
        return "GridLayout: rows: " + this.rows + ",cols: " + this.cols + ",hgap: " + this.hgap + ",vgap: " + this.vgap;
    }

    public GridLayout() {
        this(1, 0, 0, 0);
    }

    public GridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public GridLayout(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("GridLayout rows and cols cannot both be zero");
        }
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }
}

