/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -7262534875583282631L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;

    public void addLayoutComponent(String string, Component component) {
    }

    private final int alignComps(Container container, int n, int n2, int n3, int n4) {
        Insets insets = container.getInsets();
        int n5 = container.width - insets.left - insets.right;
        int n6 = 0;
        int n7 = this.align == 1 ? insets.left + (n5 - n3) / 2 : (this.align == 2 ? n5 - n3 : insets.left + this.hgap);
        int n8 = n;
        while (n8 <= n2) {
            Component component = container.getComponent(n8);
            if (component.height > n6) {
                n6 = component.height;
            }
            component.setLocation(n7, n4);
            n7 += component.width + this.hgap;
            ++n8;
        }
        return n6 + this.vgap;
    }

    public int getAlignment() {
        return this.align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.width - insets.left - insets.right;
        int n2 = this.hgap;
        int n3 = this.vgap + insets.top;
        int n4 = 0;
        int n5 = container.getComponentCount();
        int n6 = 0;
        while (n6 < n5) {
            Component component = container.getComponent(n6);
            if ((component.flags & 1) != 0) {
                component.setSize(component.getPreferredSize());
                if (n2 + component.width + this.hgap <= n) {
                    n2 += component.width + this.hgap;
                } else {
                    if (n6 == n4) {
                        component.setBounds(insets.left + this.hgap, n3, n - 2 * this.hgap, component.height);
                        ++n4;
                        n3 += component.height + this.vgap;
                    } else {
                        n3 += this.alignComps(container, n4, n6 - 1, n2, n3);
                        n4 = n6--;
                    }
                    n2 = this.hgap;
                }
            }
            ++n6;
        }
        this.alignComps(container, n4, n5 - 1, n2, n3);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredSize(container, true);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.preferredSize(container, false);
    }

    private final Dimension preferredSize(Container container, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        int n4 = 0;
        while (n4 < n3) {
            Component component = container.getComponent(n4);
            if ((component.flags & 1) != 0) {
                Dimension dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
                n += dimension.width + this.hgap;
                if (n2 < dimension.height) {
                    n2 = dimension.height;
                }
            }
            ++n4;
        }
        Insets insets = container.getInsets();
        return new Dimension(n += insets.left + insets.right + this.hgap, n2 += insets.top + insets.bottom + 2 * this.vgap);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setAlignment(int n) {
        this.align = n;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public String toString() {
        String string = this.getClass().getName() + ",vgap=" + this.vgap + ",hgap=" + this.hgap + ",align=";
        switch (this.align) {
            case 0: {
                string = string + "left";
                break;
            }
            case 1: {
                string = string + "center";
                break;
            }
            case 2: {
                string = string + "right";
                break;
            }
        }
        return string;
    }

    public FlowLayout() {
        this(1, 5, 5);
    }

    public FlowLayout(int n) {
        this(n, 5, 5);
    }

    public FlowLayout(int n, int n2, int n3) {
        this.align = n;
        this.hgap = n2;
        this.vgap = n3;
    }
}

