/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuShortcut;
import java.awt.NativeGraphics;
import java.awt.PopupMenu;
import java.awt.ShortcutConsumer;
import java.awt.ShortcutHandler;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class BarMenu
extends Component
implements ShortcutConsumer {
    static int Dx = 5;
    Menu selection;
    MenuBar mb;
    PopupMenu current;
    WindowAdapter wa;

    public void addNotify() {
        if ((this.flags & 0x400) == 0) {
            super.addNotify();
            this.mb.owner = this.getToplevel();
            this.mb.parent = this;
            this.mb.addNotify();
            this.mb.propagateOldEvents((this.flags & 0x20) != 0);
            this.registerHandlers();
        }
    }

    void disposeCurrent() {
        if (this.current != null) {
            this.unlinkCurrent();
            this.current.dispose();
            this.current = null;
        }
    }

    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeAll(this.getClass(), false);
    }

    public Graphics getGraphics() {
        int n = this.x;
        int n2 = this.y;
        if ((Toolkit.flags & 0x10) != 0) {
            n -= this.parent.deco.x;
            n2 -= this.parent.deco.y;
        }
        return NativeGraphics.getGraphics(this.parent, ((Window)this.parent).nativeData, 0, n, n2, 0, 0, this.width, this.height, this.parent.fgClr, this.parent.bgClr, this.parent.font, false);
    }

    int getX(Menu menu) {
        int n = this.mb.menus.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Menu menu2 = (Menu)this.mb.menus.elementAt(n3);
            if (menu2 == menu) {
                return n2;
            }
            n2 += menu2.getWidth() + 2 * Dx;
            ++n3;
        }
        return -1;
    }

    public void handleShortcut(MenuShortcut menuShortcut) {
        switch (menuShortcut.keyCode) {
            case 37: {
                this.selectPrev();
                break;
            }
            case 39: {
                this.selectNext();
                break;
            }
            case 10: {
                this.processSelection();
                break;
            }
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    Menu menuAt(int n) {
        int n2 = this.mb.menus.size();
        int n3 = Dx;
        int n4 = 0;
        while (n4 < n2) {
            Menu menu = (Menu)this.mb.menus.elementAt(n4);
            int n5 = menu.getWidth();
            if ((n3 += n5 + Dx) > n) {
                return menu;
            }
            n3 += Dx;
            ++n4;
        }
        return null;
    }

    boolean openSelection() {
        if (this.selection == null || this.selection.getItemCount() == 0) {
            return false;
        }
        this.disposeCurrent();
        this.current = new PopupMenu(this.selection);
        this.current.show(this, this.getX(this.selection), this.height);
        MenuShortcut menuShortcut = new MenuShortcut(this, 37, 0);
        MenuShortcut menuShortcut2 = new MenuShortcut(this, 39, 0);
        ShortcutHandler.addShortcut(menuShortcut, this.current.wnd, this);
        ShortcutHandler.addShortcut(menuShortcut2, this.current.wnd, this);
        this.current.wnd.addWindowListener(this.wa);
        return true;
    }

    public void paint(Graphics graphics) {
        int n = this.mb.menus.size();
        int n2 = 2 * Dx;
        int n3 = 1;
        int n4 = 1;
        int n5 = this.height - 2;
        graphics.setColor(this.getBackground());
        graphics.fill3DRect(0, 0, this.width, this.height, true);
        int n6 = 0;
        while (n6 < n) {
            Menu menu = (Menu)this.mb.menus.elementAt(n6);
            int n7 = menu.getWidth() + n2;
            menu.paint(graphics, n3, Dx, n4, n7, n5, this.bgClr, this.fgClr, this.selection == menu);
            n3 += n7;
            ++n6;
        }
    }

    void paintMenu(Graphics graphics, Menu menu) {
        int n = this.mb.menus.size();
        int n2 = 1;
        int n3 = 2 * Dx;
        int n4 = 1;
        int n5 = this.height - 2;
        int n6 = 0;
        while (n6 < n) {
            Menu menu2 = (Menu)this.mb.menus.elementAt(n6);
            int n7 = menu2.getWidth() + n3;
            if (menu == menu2) {
                menu2.paint(graphics, n2, Dx, n4, n7, n5, this.bgClr, this.fgClr, this.selection == menu2);
                return;
            }
            n2 += n7;
            ++n6;
        }
    }

    void processSelection() {
        if (this.selection != null && !this.openSelection()) {
            this.selection.handleShortcut(null);
            this.selectMenu(null);
        }
    }

    void registerHandlers() {
        MenuShortcut menuShortcut = new MenuShortcut(this, 37, 0);
        MenuShortcut menuShortcut2 = new MenuShortcut(this, 39, 0);
        MenuShortcut menuShortcut3 = new MenuShortcut(this, 10, 0);
        ShortcutHandler.addShortcut(menuShortcut, this, this);
        ShortcutHandler.addShortcut(menuShortcut2, this, this);
        ShortcutHandler.addShortcut(menuShortcut3, this, this);
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(this){
            private final /* synthetic */ BarMenu this$0;

            public final void mouseMoved(MouseEvent mouseEvent) {
                if (AWTEvent.keyTgt == mouseEvent.getSource() || this.this$0.current != null) {
                    this.this$0.selectMenu(this.this$0.menuAt(mouseEvent.getX()));
                }
            }
            {
                this.this$0 = barMenu;
                this.constructor$0(barMenu);
            }

            private final void constructor$0(BarMenu barMenu) {
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(this){
            private final /* synthetic */ BarMenu this$0;

            public final void mousePressed(MouseEvent mouseEvent) {
                this.this$0.requestFocus();
                this.this$0.selectMenu(this.this$0.menuAt(mouseEvent.getX()));
            }

            public final void mouseReleased(MouseEvent mouseEvent) {
                this.this$0.processSelection();
            }

            public final void mouseExited(MouseEvent mouseEvent) {
                if (this.this$0.current == null) {
                    this.this$0.selectMenu(null);
                }
            }
            {
                this.this$0 = barMenu;
                this.constructor$0(barMenu);
            }

            private final void constructor$0(BarMenu barMenu) {
            }
        };
        this.wa = new WindowAdapter(this){
            private final /* synthetic */ BarMenu this$0;

            public final void windowClosed(WindowEvent windowEvent) {
                this.this$0.selectMenu(null);
            }
            {
                this.this$0 = barMenu;
                this.constructor$0(barMenu);
            }

            private final void constructor$0(BarMenu barMenu) {
            }
        };
        this.addMouseMotionListener(mouseMotionAdapter);
        this.addMouseListener(mouseAdapter);
    }

    public void removeNotify() {
        super.addNotify();
        this.mb.removeNotify();
        ShortcutHandler.removeShortcuts(this);
    }

    void selectMenu(Menu menu) {
        Menu menu2 = this.selection;
        if (menu == this.selection) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (menu == null) {
            this.disposeCurrent();
            this.selection = null;
            this.paintMenu(graphics, menu2);
        } else if (this.selection == null) {
            this.selection = menu;
            this.paintMenu(graphics, menu);
            this.openSelection();
        } else {
            this.selection = menu;
            this.paintMenu(graphics, menu2);
            this.paintMenu(graphics, menu);
            this.disposeCurrent();
            this.openSelection();
        }
        graphics.dispose();
    }

    void selectNext() {
        try {
            if (this.selection == null) {
                this.selectMenu((Menu)this.mb.menus.firstElement());
            } else {
                int n = this.mb.menus.indexOf(this.selection) + 1;
                this.selectMenu((Menu)this.mb.menus.elementAt(n));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void selectPrev() {
        try {
            if (this.selection == null) {
                this.selectMenu((Menu)this.mb.menus.lastElement());
            } else {
                int n = this.mb.menus.indexOf(this.selection) - 1;
                this.selectMenu((Menu)this.mb.menus.elementAt(n));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setMenus(MenuBar menuBar) {
        this.mb = menuBar;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    void unlinkCurrent() {
        if (this.current != null && this.current.wnd != null) {
            ShortcutHandler.removeShortcuts(this.current.wnd);
            this.current.wnd.removeWindowListener(this.wa);
        }
    }

    public BarMenu(MenuBar menuBar) {
        this.mb = menuBar;
        this.setForeground(Defaults.MenuTxtClr);
        this.setBackground(Defaults.MenuBgClr);
        this.setFont(Defaults.MenuFont);
    }
}

