/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import kaffe.lang.Application;
import kaffe.util.NotImplemented;

public class Runtime {
    private static Runtime currentRuntime = new Runtime();
    private static kaffe.lang.MemoryAdvice advice = kaffe.lang.MemoryAdvice.getInstance();

    public Process exec(String string) throws IOException {
        return this.exec(string, null, null);
    }

    public Process exec(String string, String[] stringArray) throws IOException {
        return this.exec(string, stringArray, null);
    }

    public Process exec(String string, String[] stringArray, File file) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return this.exec(stringArray2, stringArray, file);
    }

    public Process exec(String[] stringArray) throws IOException {
        return this.exec(stringArray, null, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2) throws IOException {
        return this.exec(stringArray, stringArray2, null);
    }

    public Process exec(String[] stringArray, String[] stringArray2, File file) throws IOException {
        System.getSecurityManager().checkExec(stringArray[0]);
        return this.execInternal(stringArray, stringArray2, file);
    }

    private native Process execInternal(String[] var1, String[] var2, File var3) throws IOException;

    public void exit(int n) {
        System.getSecurityManager().checkExit(n);
        if (!Application.exit(n)) {
            this.exitInternal(n);
        }
        Thread.currentThread().destroy();
    }

    public void halt(int n) {
        this.exitInternal(n);
    }

    private native void exitInternal(int var1);

    public native long freeMemory();

    public native void gc();

    public InputStream getLocalizedInputStream(InputStream inputStream) {
        return inputStream;
    }

    public OutputStream getLocalizedOutputStream(OutputStream outputStream) {
        return outputStream;
    }

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    public void loadLibrary(String string) {
        this.loadLibrary(string, Class.getStackClass(1).getClassLoader());
    }

    void loadLibrary(String string, ClassLoader classLoader) {
        String string2;
        System.getSecurityManager().checkLink(string);
        String string3 = string + ": not found";
        String[] stringArray = classLoader != null && (string2 = classLoader.findLibrary(string)) != null ? new String[]{string2} : NativeLibrary.getLibraryNames(string);
        int n = 0;
        while (n < stringArray.length) {
            try {
                new NativeLibrary(stringArray[n], classLoader);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                string3 = unsatisfiedLinkError.getMessage();
                ++n;
            }
        }
        throw new UnsatisfiedLinkError(string3);
    }

    public void load(String string) {
        this.load(string, Class.getStackClass(1).getClassLoader());
    }

    void load(String string, ClassLoader classLoader) {
        System.getSecurityManager().checkLink(string);
        new NativeLibrary(string, classLoader);
    }

    int getMemoryAdvice() {
        return advice.getColor();
    }

    int waitForMemoryAdvice(int n) throws InterruptedException {
        return advice.waitForOtherColor(n);
    }

    public void addShutdownHook(Thread thread) {
        throw new NotImplemented(this.getClass().getName() + ".addShutdownHook()");
    }

    public boolean removeShutdownHook(Thread thread) {
        return false;
    }

    public native void runFinalization();

    public static native void runFinalizersOnExit(boolean var0);

    public native long totalMemory();

    public native void traceInstructions(boolean var1);

    public native void traceMethodCalls(boolean var1);

    private Runtime() {
    }

    public static interface MemoryAdvice {
        public static final int GREEN = 0;
        public static final int YELLOW = 1;
        public static final int ORANGE = 2;
        public static final int RED = 3;
    }
}

