/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.registry;

import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import kaffe.rmi.server.UnicastServerRef;

public class RegistryImpl
extends UnicastRemoteObject
implements Registry {
    private Hashtable bindings = new Hashtable();

    public Remote lookup(String string) throws RemoteException, NotBoundException, AccessException {
        Object v = this.bindings.get(string);
        if (v == null) {
            throw new NotBoundException(string);
        }
        return (Remote)v;
    }

    public void bind(String string, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        if (this.bindings.containsKey(string)) {
            throw new AlreadyBoundException(string);
        }
        this.bindings.put(string, remote);
    }

    public void unbind(String string) throws RemoteException, NotBoundException, AccessException {
        Object v = this.bindings.remove(string);
        if (v == null) {
            throw new NotBoundException(string);
        }
    }

    public void rebind(String string, Remote remote) throws RemoteException, AccessException {
        this.bindings.put(string, remote);
    }

    public String[] list() throws RemoteException, AccessException {
        int n = this.bindings.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.bindings.keys();
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        int n = 1099;
        if (stringArray.length > 0) {
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Bad port number - using default");
            }
        }
        try {
            Registry registry = LocateRegistry.createRegistry(n);
        }
        catch (RemoteException remoteException) {
            System.err.println("Registry failed");
        }
    }

    public RegistryImpl(int n) throws RemoteException {
        this(n, RMISocketFactory.getSocketFactory(), RMISocketFactory.getSocketFactory());
    }

    public RegistryImpl(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        super(new UnicastServerRef(new ObjID(0), n, rMIServerSocketFactory));
        ((UnicastServerRef)this.getRef()).exportObject(this);
    }
}

