/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.GapPosition;
import gnu.jemacs.buffer.GapUndoableEdit;
import gnu.jemacs.buffer.Signal;
import gnu.kawa.util.CharBuffer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;

public class BufferContent
extends CharBuffer
implements AbstractDocument.Content {
    public BufferContent() {
        this(100);
    }

    public BufferContent(int n) {
        super(n);
        this.gapEnd = n - 1;
        this.array[this.gapEnd] = 10;
    }

    public Position createPosition(int n) throws BadLocationException {
        int n2;
        int n3 = n2 = n == 0 ? 0 : 2;
        if (n < 0 || n > this.length()) {
            throw new BadLocationException("bad offset to createPosition", n);
        }
        return new GapPosition(this, n, n2);
    }

    public void dump() {
        System.err.println("Buffer Content dump.  length:" + this.length());
        System.err.print("before gap: \"");
        System.err.print(new String(this.array, 0, this.gapStart));
        System.err.println("\" (gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + ')');
        System.err.print("after gap: \"");
        System.err.print(new String(this.array, this.gapEnd, this.array.length - this.gapEnd));
        System.err.println("\"");
        int n = this.positions == null ? 0 : this.positions.length;
        System.err.println("Positions (size: " + n + "):");
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.positions[n2];
            if (n3 != 0) {
                System.err.println("position#" + n2 + ": " + (n3 >> 2) + " kind:" + (n3 & 3));
            }
            ++n2;
        }
    }

    protected int getChars(int n, int n2) throws BadLocationException {
        int n3 = this.length();
        if (n < 0 || n > n3) {
            throw new BadLocationException("bad location (in getChars)", n);
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n + n2 > n3) {
            n2 = n3 - n;
        }
        if (n + n2 <= this.gapStart) {
            return n;
        }
        if (n < this.gapStart) {
            this.shiftGap(n);
        }
        return n + (this.gapEnd - this.gapStart);
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        segment.offset = this.getChars(n, n2);
        segment.array = this.array;
        segment.count = n2;
    }

    public String getString(int n, int n2) throws BadLocationException {
        return new String(this.array, this.getChars(n, n2), n2);
    }

    public static int indexOf(char[] cArray, int n, int n2, char c) {
        int n3 = n;
        while (n3 < n2) {
            if (cArray[n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        return this.insertString(n, string, false);
    }

    public UndoableEdit insertString(int n, String string, boolean bl) throws BadLocationException {
        if (n < 0 || n > this.length()) {
            throw new BadLocationException("bad insert", n);
        }
        this.insert(n, string, bl);
        GapUndoableEdit gapUndoableEdit = new GapUndoableEdit(n);
        gapUndoableEdit.content = this;
        gapUndoableEdit.data = string;
        gapUndoableEdit.nitems = string.length();
        gapUndoableEdit.isInsertion = true;
        return gapUndoableEdit;
    }

    public static int lastIndexOf(char[] cArray, int n, int n2, char c) {
        int n3 = n;
        while (n3 >= n2) {
            if (cArray[n3] == c) {
                return n3;
            }
            --n3;
        }
        return -1;
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        if (n2 < 0 || n < 0 || n + n2 > this.length()) {
            throw new BadLocationException("invalid remove", n);
        }
        this.delete(n, n2);
        GapUndoableEdit gapUndoableEdit = new GapUndoableEdit(n);
        gapUndoableEdit.content = this;
        gapUndoableEdit.data = new String(this.array, this.gapEnd - n2, n2);
        gapUndoableEdit.nitems = n2;
        gapUndoableEdit.isInsertion = false;
        return gapUndoableEdit;
    }

    /*
     * Unable to fully structure code
     */
    public final long scan(char var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        v0 = var6_6 = var3_3 > this.gapStart ? var3_3 + this.gapEnd - this.gapStart : var3_3;
        if (var2_2 > this.gapStart) {
            var2_2 += this.gapEnd - this.gapStart;
        }
        if (var4_4 <= 0) ** GOTO lbl34
        while (var2_2 < var6_6 && var4_4 > 0) {
            if (var2_2 == this.gapStart) {
                var2_2 = this.gapEnd;
            }
            var7_7 = var2_2 < this.gapStart && var6_6 > this.gapStart ? this.gapStart : var6_6;
            if (var5_5) {
                if (var7_7 - var2_2 > 5000) {
                    var7_7 = var2_2 + 5000;
                }
                Signal.checkQuit();
            }
            if ((var8_9 = BufferContent.indexOf(this.array, var2_2, var7_7, var1_1)) >= 0) {
                --var4_4;
                var2_2 = var8_9 + 1;
                continue;
            }
            var2_2 = var7_7;
        }
        if (var2_2 > this.gapEnd) {
            var2_2 -= this.gapEnd - this.gapStart;
        }
        return (long)var4_4 << 32 | (long)var2_2;
lbl-1000:
        // 1 sources

        {
            if (var2_2 == this.gapEnd) {
                var2_2 = this.gapStart;
            }
            var7_8 = var2_2 <= this.gapStart || var6_6 >= this.gapEnd ? var6_6 : this.gapEnd;
            if (var5_5) {
                if (var2_2 - var7_8 > 5000) {
                    var7_8 = var2_2 - 5000;
                }
                Signal.checkQuit();
            }
            if ((var8_10 = BufferContent.lastIndexOf(this.array, var2_2 - 1, var7_8, var1_1)) >= 0) {
                ++var4_4;
                var2_2 = var8_10;
                continue;
            }
            var2_2 = var7_8;
lbl34:
            // 3 sources

            ** while (var2_2 > var6_6 && var4_4 < 0)
        }
lbl35:
        // 1 sources

        if (var2_2 >= this.gapEnd) {
            var2_2 -= this.gapEnd - this.gapStart;
        }
        if (var4_4 != 0) {
            return (long)(-var4_4) << 32 | (long)var2_2;
        }
        return var2_2 + 1;
    }
}

