// Template application. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "TemplateObserverSwarm.h"
#import <simtoolsgui.h>

// implementation of sample graphical interface for models.
@implementation TemplateObserverSwarm

+ createBegin: aZone
{
  TemplateObserverSwarm * obj;
  id <ProbeMap> probeMap;
  
  obj = [super createBegin: aZone];

  // MODIFY: initialize other display options here.
  obj->displayFrequency = 10000;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // MODIFY: set any display parameters here.
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

// MODIFY: possible creation finalization here
- createEnd
{
  return [super createEnd];
}

- buildObjects
{
  [super buildObjects];
  
  templateModelSwarm = [TemplateModelSwarm create: self];
  
  CREATE_PROBE_DISPLAY (templateModelSwarm);
  CREATE_PROBE_DISPLAY (self);

  [actionCache waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  [templateModelSwarm buildObjects];

  // MODIFY: build display objects here.
  observedCounter = [templateModelSwarm getCounter];
  
  return self;
}  

- buildActions
{
  [super buildActions];
  
  [templateModelSwarm buildActions];

  // MODIFY: schedule display objects here.
  displayActions = [ActionGroup create: self];
  [displayActions createActionTo: observedCounter     message: M(print)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache         message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

- activateIn: swarmContext
{
  [super activateIn: swarmContext];

  [templateModelSwarm activateIn: self];
  [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}

@end
