// Swarm library. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.


#import "DiscreteToroid.h"

@implementation DiscreteToroid

- getObjectAtX: (unsigned)inX Y: (unsigned)inY
{
  inX = [self wrapXCoord: inX];
  inY = [self wrapYCoord: inY];
  return [super getObjectAtX: inX Y: inY];
}

- putObject: anObject atX: (unsigned)inX Y: (unsigned)inY
{
  inX = [self wrapXCoord: inX];
  inY = [self wrapYCoord: inY];
  return [super putObject: anObject atX: inX Y: inY];
}

-(int)wrapCoord: (int)inCoord atModulus: (int)inModulus
{
  /* I have just tried and failed to find out
     definitively whether the behaviour of the %
     operator is well defined if either operand is
     negative.  I don't have a copy of the ISO C
     standard to hand.  My code here will at least work
     robustly (if inefficiently) *even* in the
     pathological case of large negative inCoord.  In the
     "typical" case of small negative inCoord, this code
     is fine. */
  while ((inCoord) < 0) inCoord += inModulus;
  return (inCoord % inModulus);
}

- (int)wrapXCoord: (int)inCoord
{
  return [self wrapCoord: inCoord atModulus: xsize];
}

- (int)wrapYCoord: (int)inCoord
{
  return [self wrapCoord: inCoord atModulus: ysize];
}


@end
