// Template application. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "TemplateModelSwarm.h"

// Implementation of the model for template.

@implementation TemplateModelSwarm

-(Counter *) getCounter {
  return counter;
}

+createBegin: (id) aZone {
  TemplateModelSwarm * obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];

  // MODIFY: add in defaults for your simulation parameters.
  obj->increment = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // MODIFY: add your own probes for your parameters.
  [probeMap addProbe: [probeLibrary getProbeForVariable: "increment"
				    inClass: [self class]]];
  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}

// MODIFY: possible creation objects here.
- createEnd 
{
  return [super createEnd];
}

- buildObjects 
{
  [super buildObjects];

  // MODIFY: create your simulation objects and set them up from the
  // model parameters.
  counter = [Counter create: self];
  [counter setIncr: increment];

  return self;
}

- buildActions 
{
  [super buildActions];

  // MODIFY: schedule your own agents as appropriate.
  modelActions = [ActionGroup create: self];
  [modelActions createActionTo: counter message: M(step)];

  modelSchedule = [Schedule createBegin: self];
  [modelSchedule setRepeatInterval: 1];
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

- activateIn:  swarmContext 
{
  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getSwarmActivity];
}

@end
