// Market application. Copyright  1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "define.h"	

extern prediction forecast[];			  /* The current predictors'forecasts */
extern hombre  person[];			  /* The population of agents */
extern float pastdays[];			  /* Array of past prices */
extern int predictor_use[];			  /* Counts no. of agents using predictor*/
extern float todays_price;			  /* New price */
extern float Dividend;				  /* Current dividend */
extern const char *pred[];
extern FILE *ofp, *ofplot;
extern int day;
extern int   MAXHEED;	/* Total predictors each agent notices	*/
extern double ETA;	/* Rate for updating predictor accurs. */
extern double BETA;	/* Discount rate */
extern double NU;	/* Multiplier for dividend jumps */
extern double INITIAL_DIVIDEND;
extern int   pr_text;	// print Brian Arthur's text output

 

void Initiate_agents(hombre *);
void Initiate_history(float *);
void Initiate_predictors(prediction *);
void print_forecasts(prediction *,int *);
void sort( prediction *);
void Update_accuracy(float, prediction *);
float eval_accuracy(prediction function(void));
void Choose_Best_Predictors(prediction *,hombre *);
void Count_Predictor_Use (hombre *, int *);
float Declare_New_Dividend(float);
float Make_New_Price(prediction *, hombre *);
void Update_history(float *, float);
void print_history( float *);
void fprint_history( float *);
void print_agent_predictors(hombre *);
void Make_new (prediction *);
void Make_Report(int,float *, float, prediction *, hombre *, int *);	
